% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineRegionsHelper.R
\name{crAddSummit}
\alias{crAddSummit}
\title{Update the center and score information}
\usage{
crAddSummit(
  data,
  input,
  combinedCenter = "nearest",
  annotateWithInputNames = FALSE,
  combinedSampleName = NULL
)
}
\arguments{
\item{data}{PeakCombiner data frame structure with required columns
named \code{chrom}, \code{start}, \code{end}, \code{name},
\code{score}, \code{strand}, \code{center}, \code{sample_name}. Additional
columns will be dropped}

\item{input}{The original input file from \code{combineRegions} to extract center
information}

\item{combinedCenter}{Defines how the column 'center' will be
populated for each genomic region in the output
data. Allowed options are
* \code{middle}        - the mathematical center of the new region
* \code{strongest}     - the 'center' of the input region that has the
the highest 'score' of all overlapping input
regions
* \code{nearest}       - the 'center' of the input region that is closest
to mean of the 'center's of all overlapping
input regions (default)}

\item{annotateWithInputNames}{TRUE / FALSE (default). If TRUE, a new
column named 'input_names' is created
in the output data that is populated for
each combined genomic region with the
'name's of all contributing input regions.
If the column 'input_names' already
exists, it will be overwritten.}

\item{combinedSampleName}{Optionally defines how the column 'sample_name'
is populated for the output data.
If not used, then the default is to simply
concatenate all input
sample_names into a single comma-separated
string}
}
\value{
A tibble with the following columns: \code{chrom}, \code{start}, \code{end}, \code{name},
\code{score}, \code{strand}, \code{center}, \code{sample_name}.
}
\description{
Helper function for main function \link{combineRegions}.
Requires in memory data frame in the standard accepted format for the
peakCombiner package.
For details see the details for \link{combineRegions}.
}
\details{
As you can use the output data from this step again (e.g., to
center and expand the new set of consensus regions), we must define
the 'center', 'score', 'sample_name', and 'name' values for the new
genomic regions. We do this as follows:
\itemize{
\item 'center' is defined by the \code{combinedCenter} parameter, which has three
options.
* \code{middle}        - the mathematical center of the new region
* \code{strongest}     - the 'center' of the input region that has the
the highest 'score' of all overlapping input
regions
* \code{nearest}       - the 'center' of the input region that is closest
to mean of the 'center's of all overlapping
input regions (default)
\item 'score' is the score of the genomic region from the sample whose
'center's was used, or the mean of the 'score's if \code{middle} was selected
for the \code{combinedCenter} parameter
\item 'sample_name' is a concatenated string of all input sample_names
}

In addition, the output data.frame columns \code{sample_name}, \code{name} and \code{score}
will be updated.
}
