% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenopath.R
\name{phenopath}
\alias{phenopath}
\title{PhenoPath - genomic trajectories with heterogeneous backgrounds}
\usage{
phenopath(exprs_obj, x, sce_assay = "exprs", elbo_tol = 1e-05, z_init = 1,
  ...)
}
\arguments{
\item{exprs_obj}{Input gene expression, either
\enumerate{
\item An \linkS4class{SummarizedExperiment} object, \emph{or}
\item A cell-by-gene matrix of normalised expression values in log form.
}}

\item{x}{The covariate vector, either
\enumerate{
\item The name of a column of \code{colData(exprs_obj)} if \code{exprs_obj} is an
\code{SummarizedExperiment}, \emph{or}
\item A numeric of factor vector of length equal to the 
number of cells, \emph{or}
\item A formula from which to build a model matrix from \code{colData(exprs_obj)}, 
if \code{exprs_obj} is a \linkS4class{SummarizedExperiment}
}}

\item{sce_assay}{The assay from \code{exprs_obj} to use as expression if
\code{exprs_object} is a \code{SummarizedExperiment}}

\item{elbo_tol}{The relative pct change in the ELBO below 
which is considered converged.
See convergence section in details below.}

\item{z_init}{The initialisation of the latent trajectory. Should be one of
\enumerate{
\item A positive integer describing which principal component of the data should
be used for initialisation (default 1), \emph{or}
\item A numeric vector of length number of samples to be used 
directly for initialisation, \emph{or}
\item The text character \code{"random"}, for random initialisation 
from a standard normal distribution.
}}

\item{...}{Additional arguments to be passed to \code{\link{clvm}}. 
See description below for more details or call \code{?clvm}.}
}
\value{
An S3 structure with the following entries:
\itemize{
\item \code{m_z} The converged mean estimates of the trajectory
\item \code{s_z} The converged standard deviation estimates of z
\item \code{m_beta} A P-by-G matrix of interaction coefficients
\item \code{s_beta} A P-by-G matrix of interaction standard deviations
}
}
\description{
PhenoPath learns genomic trajectories in the presence of 
heterogenous environmental and genetic backgrounds. It takes 
input gene expression measurements that are modelled
by a single unobserved factor (the "trajectory"). The regulation 
of genes along the trajectory is perturbed by an additional set of 
covariates (such as genetic or environmental status) allowing for 
the identification of covariate-trajectory interactions.
The model is fitted using mean-field co-ordinate ascent variational inference.
}
\details{
\strong{Input expression}

If an \code{SummarizedExperiment} is provided, \code{assay(exprs_obj, sce_assay)} 
is used. 
This is assumed to be in
a form that is suitably normalised and approximately normal, such as 
the log of TPM values (plus a suitable offset) or 
similar.

\strong{Encoding covariates}

See the vignette.

\strong{Convergence of variational inference}

It is strongly recommended to call \code{plot_elbo(phenopath_fit)} after the fitting procedure to
ensure the ELBO has approximately converged (though convergence metrics are printed during the
fitting process). For a good introduction to variational inference see Blei, D.M., Kucukelbir, A. & McAuliffe, J.D., 2017. Variational Inference: A Review for Statisticians. Journal of the American Statistical Association.

\strong{Additional arguments}

Addition arguments to \code{clvm} are passed via \code{...}. For full documentation, call \code{?clvm}.
Some notable options:
\itemize{
\item \code{thin} - The ELBO is expensive to compute for larger datasets. The model will
compute the ELBO and compare convergence every \code{thin} iterations.
\item \code{q} and \code{tau_q} - Priors (such as capture times) for the latent space. Note that
\code{model_mu} should be true if \code{q} is non-zero.
\item \code{scale_y} By default the input expression is centre-scaled for each gene. If \code{scale_y}
is \code{FALSE} this does not happen - but note that \code{model_mu} should be \code{TRUE} in such a case.
}
}
\examples{
sim <- simulate_phenopath() # returns a list with gene expression in y and covariates in x
fit <- phenopath(sim$y, sim$x, elbo_tol = 1e-2)

# Extract the trajectory
z <- trajectory(fit)

}
\seealso{
\code{\link{clvm}} for the underlying CAVI function, \code{\link{trajectory}}
to extract the latent trajectory, \code{\link{interaction_effects}} for the interaction effect
sizes, \code{\link{significant_interactions}} for the results of Bayesian significance testing.
}
