% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch_length_calculations.R
\name{mean_dist_to_tips}
\alias{mean_dist_to_tips}
\title{Mean distance from internal nodes to descendant tips}
\usage{
mean_dist_to_tips(tree)
}
\arguments{
\item{tree}{a \code{phylo} class tree object that is binary (see
\code{\link[ape]{multi2di}})}
}
\value{
vector (named if internal nodes are named)
}
\description{
Calculates the mean distance from each internal node to its descendant tips
}
\details{
This is a function used by \code{\link{calculate.blw}} when
  \code{method='mean.descendants'}, there this function is called twice, once
  for each direct child of a given internal node and the results are summed
  for each node.
}
\examples{
tr <- named_rtree(5)
mean_dist_to_tips(tr)
}
