% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrna_evaluationFunctions.R
\name{evaluateClustering}
\alias{evaluateClustering}
\title{evaluateClustering}
\usage{
evaluateClustering(x, tl = NULL)
}
\arguments{
\item{x}{The clustering labels}

\item{tl}{The true labels}
}
\value{
A numeric vector of metrics (see the `pipeComp_scRNA` vignette for 
details)
}
\description{
Evaluates a clustering using 'true' labels. Entries with missing true labels
(i.e. NA) are excluded from calculations. If using `evaluteClustering` in a
custom pipeline, you might want to use the corresponding 
`pipeComp:::.aggregateClusterEvaluation` aggregation function.
}
\examples{
# random data
dat <- data.frame( 
 cluster=rep(LETTERS[1:3], each=10),
 x=c(rnorm(20, 0), rnorm(10, 1)),
 y=c(rnorm(10, 1), rnorm(20, 0))
)
# clustering
dat$predicted <- kmeans(dist(dat[,-1]),3)$cluster
# evaluation
evaluateClustering(dat$predicted, dat$cluster)
}
