% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dea_evaluationFunctions.R
\name{evaluateDEA}
\alias{evaluateDEA}
\title{evaluateDEA}
\usage{
evaluateDEA(dea, truth = NULL, th = c(0.01, 0.05, 0.1))
}
\arguments{
\item{dea}{Expects a data.frame with logFC and FDR, as produced by 
`edgeR::topTags`, `limma::topTable` or `DESeq2::results`.}

\item{truth}{A data.frame containing the columns `expected.beta` (real logFC)
and `isDE` (logical indicating whether there is a difference or not; accepts
NA values)}

\item{th}{The significance thresholds for which to compute the metrics.}
}
\value{
A list with two slots: `logFC` (vector of metrics on logFC) and 
`significance` table of significance-related statistics.
}
\description{
Evaluates a differential expression analysis (DEA).
}
\examples{
# fake DEA results
dea <- data.frame( row.names=paste0("gene",1:10), logFC=rnorm(10) )
dea$PValue <- dea$FDR <- c(2:8/100, 0.2, 0.5, 1)
truth <- data.frame( row.names=paste0("gene",1:10), expected.beta=rnorm(10),
                     isDE=rep(c(TRUE,FALSE,TRUE,FALSE), c(3,1,2,4)) )
evaluateDEA(dea, truth)
}
