% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrna_plot.R
\name{scrna_evalPlot_silh}
\alias{scrna_evalPlot_silh}
\title{scrna_evalPlot_silh}
\usage{
scrna_evalPlot_silh(
  res,
  what = c("minSilWidth", "meanSilWidth"),
  step = "dimreduction",
  dims = 1,
  agg.by = NULL,
  agg.fn = mean,
  filterExpr = NULL,
  value_format = "",
  reorder_rows = FALSE,
  reorder_columns = TRUE,
  show_heatmap_legend = TRUE,
  show_column_names = FALSE,
  col = rev(RColorBrewer::brewer.pal(n = 11, "RdBu")),
  font_factor = 0.9,
  row_split = NULL,
  shortNames = TRUE,
  value_cols = c("white", "black"),
  title = NULL,
  anno_legend = TRUE,
  ...
)
}
\arguments{
\item{res}{Aggregated pipeline results (i.e. the output of `runPipeline` or
`aggregateResults`)}

\item{what}{What metric to plot, possible values are “minSilWidth”, 
“meanSilWidth” (default), “medianSilWidth”, or “maxSilWidth”.}

\item{step}{Name of the step for which to plot the evaluation results. 
Defaults to "dimreduction".}

\item{dims}{If multiple sets of dimensions are available, which one to use
(defaults to the first).}

\item{agg.by}{Aggregate results by these columns (default no aggregation)}

\item{agg.fn}{Function for aggregation (default mean)}

\item{filterExpr}{An optional filtering expression based on the columns of 
the target dataframe, (e.g. `filterExpr=param1=="value1"`).}

\item{value_format}{Format for displaying cells' values (no label by default)}

\item{reorder_rows}{Whether to sort rows (default FALSE). The row 
names themselves can also be passed to specify an order, or a 
`ComplexHeatmap`.}

\item{reorder_columns}{Whether to sort columns (default TRUE).}

\item{show_heatmap_legend}{Passed to `Heatmap` (default FALSE)}

\item{show_column_names}{Passed to `Heatmap` (default FALSE)}

\item{col}{Colors for the heatmap}

\item{font_factor}{A scaling factor applied to fontsizes (default 1)}

\item{row_split}{Optional column (included in `agg.by`) by which to split
the rows. Alternatively, an expression using the columns (retained after
aggregation) can be passed.}

\item{shortNames}{Logical; whether to use short row names (with only
the parameter values instead of the parameter name and value pairs), default
TRUE.}

\item{value_cols}{A vector of length 2 indicating the colors of the values
(above and below the mean), if printed}

\item{title}{Plot title}

\item{anno_legend}{Logical; whether to plot the legend for the datasets}

\item{...}{Passed to `Heatmap`}
}
\value{
A Heatmap
}
\description{
Plot a min/max/mean/median silhouette width heatmap from aggregated 
evaluation results of the `scrna_pipeline`.
}
\examples{
data("exampleResults", package="pipeComp")
scrna_evalPlot_silh( exampleResults, agg.by=c("filt","norm"), 
                     row_split="norm" )
}
