% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pagePlotPlace.R
\name{pagePlotPlace}
\alias{pagePlotPlace}
\title{Place a plot that has been previously created but not drawn}
\usage{
pagePlotPlace(
    plot,
    x = NULL,
    y = NULL,
    width = NULL,
    height = NULL,
    just = c("left", "top"),
    default.units = "inches",
    draw = TRUE,
    params = NULL
)
}
\arguments{
\item{plot}{Plot object to be placed, defined by the
output of a plotgardener plotting function.}

\item{x}{A numeric or unit object specifying plot x-location.}

\item{y}{A numeric, unit object, or character containing a "b" combined
with a numeric value specifying plot y-location.
The character value will place the plot y relative to the bottom
of the most recently plotted plot according to the units
of the plotgardener page.}

\item{width}{A numeric or unit object specifying plot width.}

\item{height}{A numeric or unit object specifying plot height.}

\item{just}{Justification of plot relative to its (x, y) location.
If there are two values, the first value specifies horizontal
justification and the second value specifies vertical justification.
Possible string values are: \code{"left"}, \code{"right"},
\code{"centre"}, \code{"center"}, \code{"bottom"}, and \code{"top"}.
Default value is \code{just = c("left", "top")}.}

\item{default.units}{A string indicating the default units to use
if \code{x}, \code{y}, \code{width}, or \code{height} are only
given as numerics. Default value is \code{default.units = "inches"}.}

\item{draw}{A logical value indicating whether graphics output
should be produced. Default value is \code{draw = TRUE}.}

\item{params}{An optional \link[plotgardener]{pgParams} object
containing relevant function parameters.}
}
\value{
Function will update dimensions of an input plot and
return an updated plot object.
}
\description{
Place a plot that has been previously created but not drawn
}
\examples{
## Load Hi-C data
library(plotgardenerData)
data("IMR90_HiC_10kb")

## Create, but do not plot, square Hi-C plot
hicPlot <- plotHicSquare(
    data = IMR90_HiC_10kb, resolution = 10000,
    zrange = c(0, 70),
    chrom = "chr21",
    chromstart = 28000000, chromend = 30300000,
    draw = FALSE
)

## Create page
pageCreate(width = 3.75, height = 3.5, default.units = "inches")

## Place Hi-C plot on page
pagePlotPlace(
    plot = hicPlot,
    x = 0.25, y = 0.25, width = 3, height = 3,
    just = c("left", "top"),
    default.units = "inches", draw = TRUE
)

## Annotate heatmap legend
annoHeatmapLegend(
    plot = hicPlot,
    x = 3.4, y = 0.25, width = 0.12, height = 1.2,
    just = c("left", "top"), default.units = "inches"
)

## Hide page guides
pageGuideHide()
}
