% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count-overlaps.R
\name{ginteractions-count-overlaps}
\alias{ginteractions-count-overlaps}
\alias{count_overlaps.PinnedGInteractions}
\alias{count_overlaps.GInteractions}
\alias{count_overlaps_directed.PinnedGInteractions}
\alias{count_overlaps_directed.GInteractions}
\title{Count overlaps between a query GInteractions and a GRanges}
\usage{
\method{count_overlaps}{PinnedGInteractions}(x, y, maxgap = -1L, minoverlap = 0L)

\method{count_overlaps}{GInteractions}(x, y, maxgap = -1L, minoverlap = 0L)

\method{count_overlaps_directed}{PinnedGInteractions}(x, y, maxgap = -1L, minoverlap = 0L)

\method{count_overlaps_directed}{GInteractions}(x, y, maxgap = -1L, minoverlap = 0L)
}
\arguments{
\item{x}{A (Pinned)GInteractions object}

\item{y}{A GRanges object}

\item{maxgap, minoverlap}{See \code{?\link[GenomicRanges]{countOverlaps}}
in the \pkg{GenomicRanges} package for a description of these arguments}
}
\value{
An integer vector of same length as x.
}
\description{
Count overlaps between a query GInteractions and a GRanges
}
\section{Pinned \code{GInteractions}}{


When using \code{count_overlaps()} with a \code{PinnedGInteractions} object,
only the pinned anchors are used to check for overlap with \code{y}.
This is equivalent to specifying \code{use.region="both"} in
\code{InteractionSet::findOverlaps()}.
}

\examples{
gi <- read.table(text = "  
    chr1 11 20 - chr1 21 30 + 
    chr1 11 20 - chr1 51 55 + 
    chr1 21 30 - chr1 51 55 + 
    chr1 21 30 - chr2 51 60 +",  
    col.names = c(
        "seqnames1", "start1", "end1", "strand1", 
        "seqnames2", "start2", "end2", "strand2"
    )
) |> as_ginteractions() |> mutate(id = 1:4, type = 'gi')

gr <- GenomicRanges::GRanges(
    c("chr1:20-30:+", "chr2:55-65:-")
) |> plyranges::mutate(id = 1:2, type = 'gr')

gi

gr

####################################################################
# 1. Count overlaps between GInteractions and a subject GRanges
####################################################################

count_overlaps(gi, gr)

count_overlaps_directed(gi, gr)

####################################################################
# 2. Count overlaps between PinnedGInteractions and a subject GRanges
####################################################################

gi |> pin_by("first") |> count_overlaps(gr)

gi |> pin_by("second") |> count_overlaps(gr)

gi |> pin_by("first") |> count_overlaps_directed(gr)

gi |> pin_by("second") |> count_overlaps_directed(gr)
}
