/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.LocalVariable;

public final class GeneratedCodeMethod
implements CodeMethod {
    private final String name;
    private List args;
    private List localvars;
    private LocalVariable thisV;
    private int modifiers;
    private CodeClass type;
    private CodeClass container;
    private Set thrownExceptions = new HashSet();
    private Map nameToLocals;

    GeneratedCodeMethod(CodeClass codeClass, String string, CodeClass codeClass2, CodeClass[] codeClassArray, String[] stringArray, int n) {
        this.container = codeClass;
        this.name = string;
        this.args = new ArrayList<CodeClass>(Arrays.asList(codeClassArray));
        this.modifiers = n;
        this.type = codeClass2;
        this.nameToLocals = new HashMap();
        this.localvars = new ArrayList();
        int n2 = 0;
        while (n2 < this.args.size()) {
            if (n2 < stringArray.length) {
                LocalVariable localVariable = new LocalVariable(codeClassArray[n2], stringArray[n2]);
                this.localvars.add(localVariable);
                this.nameToLocals.put(stringArray[n2], localVariable);
            } else {
                this.localvars.add(new LocalVariable(codeClassArray[n2]));
            }
            ++n2;
        }
        if ((n & 8) == 0) {
            this.thisV = new LocalVariable(codeClass, "this");
            this.nameToLocals.put("this", this.thisV);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.container.getName() + "." + this.name;
    }

    public CodeClass getContainingClass() {
        return this.container;
    }

    public String getDescriptor() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Iterator iterator = this.args.iterator();
        while (iterator.hasNext()) {
            CodeClass codeClass = (CodeClass)iterator.next();
            stringBuffer.append(codeClass.getDescriptor());
        }
        stringBuffer.append(')');
        stringBuffer.append(this.type.getDescriptor());
        return stringBuffer.toString();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public CodeClass getReturnType() {
        return this.type;
    }

    public CodeClass getParameterType(int n) {
        return (CodeClass)this.args.get(n);
    }

    public LocalVariable getVariable(int n) {
        return (LocalVariable)this.localvars.get(n);
    }

    public LocalVariable getVariable(String string) throws NoSuchElementException {
        LocalVariable localVariable = (LocalVariable)this.nameToLocals.get(string);
        if (localVariable == null) {
            throw new NoSuchElementException("Can't find local for argName " + string);
        }
        return localVariable;
    }

    public LocalVariable getThis() {
        return this.thisV;
    }

    public Set getThrownExceptions() {
        return Collections.unmodifiableSet(this.thrownExceptions);
    }

    public int numParameters() {
        return this.args.size();
    }

    public void addThrownException(CodeClass codeClass) {
        this.thrownExceptions.add(codeClass);
    }
}

