% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_miRNA_track.R
\name{plot_primiRNA}
\alias{plot_primiRNA}
\title{Plot the result of prediction for miRNA}
\usage{
plot_primiRNA(
  expressed_mir,
  bed_merged,
  flanking_num = 1000,
  threshold = 0.7,
  ignore_DHS_check = TRUE,
  DHS,
  allmirdhs_byforce = TRUE,
  expressed_gene = "all",
  allmirgene_byforce = TRUE
)
}
\arguments{
\item{expressed_mir}{This parameter allows users to specify certain miRNAs,
the TSSs of which they want to search for by providing a list of
miRNAs(e.g. expressed miRNAs in a certain cell-line). If
\code{expressed_mir} is not specified, the default value of the parameter
is "\code{all}" and the function will acquiescently employ all the miRNAs
currently listed on "\code{miRbase}" database.}

\item{bed_merged}{Peaks from ChIP-seq data to be provided for analysis can be
H3K4me3 peaks, Pol II peaks or both. Notice that peaks are supposed to be
merged(see also \code{\link{peak_merge}}) before \code{find_TSS} if using
only one kind of peak data, while peaks shoud be firstly merged and then
join together(see also \code{\link{peak_join}}) if both H3K4me3 data and
Pol II are input.}

\item{flanking_num}{A parameter in Eponine model to detect TSSs. It is
concluded that a peak signal with flanking regions of C-G enrichment are
important to mark TSSs. The default value is 1000.}

\item{threshold}{Threshold for candidate TSSs scored with Eponine method. The
default value is 0.7.}

\item{ignore_DHS_check}{The process of DHS_check further assist to filter
putative TSSs. When there are a DHS peak that locates within 1 kb upstream
of a putative TSS, this predicted TSS will be retain for it character is
consistent with that of an authentic TSS. Or the TSSs with no DHSs locating
within 1 kb upstream of them would be discard.}

\item{DHS}{ChIP-seq data of DNase I hypersensitive sites(DHSs).}

\item{allmirdhs_byforce}{When we use DHS data to check the validity of TSSs,
there is possibility where no DHSs locates within 1 kb upstream of all
putative TSSs and all these putative TSSs might be filtered out by our
method resulting no outputs. While "\code{allmirdhs_byforce} = TRUE", it
ensures to output at least 1 most possible TSS even if the nearest DHS
signal locates more than 1 kb upsteam of this TSS.}

\item{expressed_gene}{Users can speicify genes expressed in certain
cell-lines that is analyzed. Or the default value is "\code{all}", which
means all the expressed genes annotated on Ensemble will be employed.}

\item{allmirgene_byforce}{While integrating expressed_gene data to improve
prediction, there might be a circumstance where all the putative TSS are
discarded. To prevent this condition, users are allowed to use
"\code{allmirgene_byforce = TRUE}" to ensure at least 1 putative TSS for
each miRNA will be output.}
}
\value{
There will be six tracks plotted as return:

\code{Chrom}: Position of miRNA on the chromosome.

\code{hg38}: Reference genome coordinate in hg38.

\code{pri-miRNA}: Position of pri-miRNA.

\code{Ensemble genes}: Position of related protein-coding gene.

\code{eponine score}: Score of best putative TSS conducted by eponine method.

\code{conservation score}: Conservation score should be integrated with
eponine score to find out putative TSSs.
}
\description{
For each miRNA, plot the position of TSS, pri-miRNA, related Ensemble gene,
eponine socre and conservation score according to the result of prediction
using primirTSS.
}
\details{
NOTICE that this function is used for visualizing the predicted result of
ONLY ONE specific miRNA every single time.
}
\examples{
expressed_mir <- "hsa-mir-5697"
bed_merged <- data.frame(
  chrom = c("chr1", "chr1", "chr1", "chr1", "chr2"),
  start = c(9180799, 9201483, 9234339, 9942202, 9830615),
  end = c(9183889, 9202580, 9235853, 9944469, 9917994),
  stringsAsFactors = FALSE
)
bed_merged <- as(bed_merged, "GRanges")
\dontrun{
plot_primiRNA(expressed_mir, bed_merged)
}

}
