% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-proActiv.R
\name{plotPCA}
\alias{plotPCA}
\title{Performs principal component analysis}
\usage{
plotPCA(
  result,
  by = "absolutePromoterActivity",
  main = NULL,
  col = NULL,
  alpha = 0.75,
  cex.size = 2
)
}
\arguments{
\item{result}{A SummarizedExperiment object return by proActiv, with assays 
giving promoter counts and activity with gene expression stored as 
metadata. rowData contains promoter metadata and absolute promoter 
activity summarized across conditions. Condition must be provided.}

\item{by}{A character vector. The assay to perform principal component 
analysis by. One of promoterCounts, normalizedPromoterCounts, 
absolutePromoterActivity and geneExpression (unambiguous substrings can be 
supplied). Defaults to absolutePromoterActivity.}

\item{main}{A character vector. Plot title (optional). Defaults to NULL.}

\item{col}{A vector of colours. If NULL, uses standard ggplot colours. 
Defaults to NULL.}

\item{alpha}{A numeric value in between 0 and 1. Determines point 
transparency.}

\item{cex.size}{A numeric value. Determines point size.}
}
\value{
PCA plot.
}
\description{
Performs principal component analysis
}
\examples{
files <- list.files(system.file('extdata/vignette/junctions', 
                       package = 'proActiv'), 
                       full.names = TRUE, pattern = 'replicate5')
promoterAnnotation <- promoterAnnotation.gencode.v34.subset
result <- proActiv(files = files,
                       promoterAnnotation  = promoterAnnotation,
                       condition = rep(c('A549', 'HepG2'), each=1),
                       fileLabels = NULL,
                       ncores = 1)
result <- result[complete.cases(assays(result)[[1]]),]
plotPCA(result)

}
