% Generated by roxygen2 (4.0.1): do not edit by hand
\name{PrepareAnnotationGENCODE}
\alias{PrepareAnnotationGENCODE}
\title{prepare annotation from GENCODE}
\usage{
PrepareAnnotationGENCODE(gtfFile, CDSfasta, pepfasta, annotation_path,
    dbsnp = NULL, splice_matrix = FALSE, COSMIC = FALSE, ...)
}
\arguments{
\item{gtfFile}{specify GTF file location.}

\item{CDSfasta}{path to the fasta file of coding sequence.}

\item{pepfasta}{path to the fasta file of protein sequence.}

\item{annotation_path}{specify a folder to store all the annotations.}

\item{dbsnp}{specify a snp dataset to be used for the SNP annotation,
default is NULL. (e.g. "snp135")}

\item{splice_matrix}{whether generate a known exon splice matrix from the
annotation. this is not necessary if you don't want to analyse junction
results, default is FALSE.}

\item{COSMIC}{whether to download COSMIC data, default is FALSE.}

\item{...}{additional arguments}
}
\value{
several .RData files containing annotations needed for further
analysis.
}
\description{
prepare the annotation from GENCODE. Download GTF and FASTA files from
GENCODE ftp first. Read introduction for more information.
}
\examples{
gtfFile <- system.file("extdata", "test.gtf", package="proBAMr")
CDSfasta <- system.file("extdata", "coding_seq.fasta", package="proBAMr")
pepfasta <- system.file("extdata", "pro_seq.fasta", package="proBAMr")
annotation_path <- tempdir()
PrepareAnnotationGENCODE(gtfFile, CDSfasta, pepfasta,
                annotation_path, dbsnp=NULL,
                splice_matrix=FALSE, COSMIC=FALSE)
}
\author{
Xiaojing Wang
}

