% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileScoreDist.R
\name{regularizeMatrix}
\alias{regularizeMatrix}
\title{Careful regularization (pseudocount addition) to a position count matrix.}
\usage{
regularizeMatrix(motif, E = 1.5)
}
\arguments{
\item{motif}{A position count matrix; each column a position and each row a
base corresponding to A, C, G, T.  This order is assumed, unless the rows
are correspondingly named in a different order.}

\item{E}{Weighting parameter between 0 and 3 for the regularization.}
}
\value{
The regularized matrix
}
\description{
Carries out the regularization suggested by Rahmann et al.  This lets each
column in the regularized matrix be a linear combination of the column in the
non-regularized matrix and rho, the overall base distribution of all
positions.  The weighting of the linear combination is determined by the
parameter E in a non-trivial way, see Rahmann et al. for more information.  A
default value E=1.5 usually works well.
}
\examples{
data(INR)
regularizeMatrix(INR)
}
\references{
Rahmann, S., Mueller, T., and Vingron, M. (2003). On the power of
  profiles for transcription factor binding site detection. Stat Appl Genet
  Mol Biol 2, Article7.
}

