% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alluvialMat.R
\name{alluvialMat}
\alias{alluvialMat}
\title{alluvialMat}
\usage{
alluvialMat(
  projection,
  annotations,
  annotationName = "Cell type",
  annotationType = "Cell",
  plot = TRUE,
  minPropExplained = 0.75,
  pvalThreshold = 0.05,
  qvalThreshold = 0.05
)
}
\arguments{
\item{projection}{a projection generated from projectR, ensure that full = TRUE while generating projection}

\item{annotations}{a character vector of annotations for the data}

\item{annotationName}{a charcter fof collective name of the annotations, default is "Cell type"}

\item{annotationType}{a character indicating the type of data annotated, default is "Cell"}

\item{plot}{logical indicating whether to return the alluvial plot, default is TRUE}

\item{minPropExplained}{threshold for minimum proportion of samples that correspond to a pattern to be used for plotting}

\item{pvalThreshold}{theshold level of significance for p-value}

\item{qvalThreshold}{theshold level of significance for Benjamini-Hochberg corrected p-value}
}
\value{
A matrix to generate alluvial plots
}
\description{
Function to provide alluvial matrix for generating alluvial plot
}
\examples{
projection <- projectR(data=p.ESepiGen4c1l$mRNA.Seq,loadings=AP.RNAseq6l3c3t$Amean,
dataNames = map.ESepiGen4c1l[["GeneSymbols"]], full = TRUE)
alluvialMat(projection,pd.ESepiGen4c1l$Condition)
}
