% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer_spot_functions.R
\name{plot_buffer}
\alias{plot_buffer}
\title{Plot the buffer values}
\usage{
plot_buffer(
  df = buffers,
  buffer_names = "antigen",
  buffer_mfi = "FMedianBG_correct",
  slide_id = ".id"
)
}
\arguments{
\item{df}{A data frame to be used to plot}

\item{buffer_names}{A character string containing the name of the variable
with buffer spots. Default set to 'antigen'.}

\item{buffer_mfi}{A character string containing the name of the variable with
MFI value.Assuming background correction is done already.
Default to 'FMedianBG_correct'}

\item{slide_id}{A character string containing the name of the slide/array
identifier variable.}
}
\value{
plot of buffer spots
}
\description{
Plot the buffer values
}
\examples{
buffers <- readr::read_csv(system.file("extdata", "buffers_sample2.csv",
package="protGear"))
plot_buffer(df=buffers,buffer_names = "sampleID")
}
