% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_miso.R
\name{getValidEvents}
\alias{getValidEvents}
\title{Filters the events with valid elements according to the given validator}
\usage{
getValidEvents(event, validator, areMultipleExonsValid = FALSE)
}
\arguments{
\item{event}{Data.frame containing only one event with at least 7 columns as 
retrieved from the alternative splicing annotation files from MISO (GFF3
files)}

\item{validator}{Character: valid elements for each event}

\item{areMultipleExonsValid}{Boolean: consider runs of exons as valid when
comparing with the validator? Default is \code{FALSE} (see details)}
}
\value{
Data.frame with valid events
}
\description{
Filters the events with valid elements according to the given validator
}
\details{
\code{areMultipleExonsValid} allows to consider runs of exons (i.e. 
sequences where \code{exon} occurs consecutively) as valid when comparing
based on the \code{validator}. For example, if \code{validator = c("gene",
"mRNA", "exon")} and \code{areMultipleExonsValid = FALSE}, the event 
\code{c("gene", "mRNA", "exon", "exon")} is not valid as it has one 
additional exon. If \code{areMultipleExonsValid = TRUE}, the same event would
be valid.
}
\examples{
event <- read.table(text = "
 chr1 SE gene 17233 18061  .  -  .
 chr1 SE dkfd 00000 30000  .  -  .
 chr1 SE mRNA 17233 18061  .  -  .
 chr1 SE exon 17233 17368  .  -  .
 chr1 SE exon 17526 17742  .  -  .
 chr1 SE exon 17915 18061  .  -  .
 chr1 SE mRNA 17233 18061  .  -  .
 chr1 SE exon 17233 17368  .  -  .
 chr1 SE exon 17915 18061  .  -  .
 chr1 SE gene 17233 18061  .  -  .
 chr1 SE mRNA 17233 18061  .  -  .
 chr1 SE exon 17233 17368  .  -  .
 chr1 SE exon 17606 17742  .  -  .
 chr1 SE exon 17915 18061  .  -  .
 chr1 SE mRNA 17233 18061  .  -  .
 chr1 SE exon 17233 17368  .  -  .
 chr1 SE exon 17915 18061  .  -  .
")
validator <- c("gene", "mRNA", rep("exon", 3), "mRNA", rep("exon", 2))
psichomics:::getValidEvents(event, validator)
}
\keyword{internal}
