% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peak_detection.R
\name{LocalMaximaSG}
\alias{LocalMaximaSG}
\title{Find local maxima with Savitzky Golay filter}
\usage{
LocalMaximaSG(sp, minPeakHeight = -Inf, noiseacf = 0.1, d = 3)
}
\arguments{
\item{sp}{the array of spectrum values}

\item{minPeakHeight}{minimum intensity of a peak}

\item{noiseacf}{autocorrelation of the noise}

\item{d}{the degree of Savitzky Golay filter, defalut 3}
}
\value{
array with peak's index in the spectrum
}
\description{
Apply Savitzky Golay filter to the spectrum and find local maxima such that : 
second derivate Savitzky Golay filter < 0 and first derivate = 0 and 
intensity >  minPeakHeight
}
\examples{
spectrum<-dnorm(x=seq(-5,5,length.out = 100))
index.max<-LocalMaximaSG(spectrum)
}
