% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCorr.R
\name{plotCorr}
\alias{plotCorr}
\title{Correlation plot}
\usage{
plotCorr(
  x,
  i,
  type = c("sample", "feature"),
  log2 = FALSE,
  use = c("everything", "all.obs", "complete.obs", "na.or.complete",
    "pairwise.complete.obs"),
  method = c("pearson", "kendall", "spearman"),
  dendrogram = TRUE,
  colors = (scales::viridis_pal())(256),
  label = FALSE,
  digits = 2,
  widths = c(0.8, 0.2),
  heights = c(0.2, 0.8),
  hide_colorbar = FALSE,
  showticklabels = c(TRUE, TRUE),
  row_dend_left = FALSE,
  k_row = 1,
  k_col = 1,
  ...
)
}
\arguments{
\item{x}{A matrix-like object or \linkS4class{SummarizedExperiment} object.}

\item{i}{A string or integer value specifying which assay values to use
when \code{x} is a SummarizedExperiment object.}

\item{type}{A string specifying whether a correlation matrix is computed
based on samples or features.}

\item{log2}{A logical specifying whether feature intensities needs to be
log2-transformed before calculating a correlation matrix.}

\item{use}{A string specifying which method to compute correlations in the
presence of missing values. Refer to \code{?cor} for details.}

\item{method}{A string specifying which correlation coefficient is to be
computed. See \code{?cor} for details.}

\item{dendrogram}{A logical specifying whether dendogram is computed and
reordering is performed.}

\item{colors}{A vector of colors for the heatmap.}

\item{label}{A logical specifying whether cell values are shown.}

\item{digits}{A numeric value specifying the desired number of digits when
\code{label = TRUE}.}

\item{widths}{A numeric vectors specifying relative widths of heatmap and
dendrogram.}

\item{heights}{A numeric vectors specifying relative heights of heatmap and
dendrogram.}

\item{hide_colorbar}{A logical specifying whether the color bar (legend) is
hidden.}

\item{showticklabels}{A logical vector of length 2 (x-axis, y-axis)
specifying whether the ticks are removed from the sides of the plot.}

\item{row_dend_left}{A logical controlling whether the row dendrogram is
placed on the left on the plot.}

\item{k_row}{A numeric value specifying the desired number of groups by
which to color the dendrogram's branches in the rows. If \code{NA}, then
\link[dendextend:find_k]{dendextend::find_k} is used to deduce the optimal number of clusters.}

\item{k_col}{A numeric value specifying the desired number of groups by
which to color the dendrogram's branches in the columns. If \code{NA}, then
\link[dendextend:find_k]{dendextend::find_k} is used to deduce the optimal number of clusters.}

\item{...}{Additional arguments passed to \link[heatmaply:heatmaply]{heatmaply::heatmaply}.}
}
\value{
A patchwork object of aligned ggplots.
}
\description{
Visualizes correlations between samples or features with a
\linkS4class{SummarizedExperiment} or matrix-like object where rows
represent features and columns represent samples. A correlation matrix is
visualized using a heatmap with dendrograms.
}
\examples{

data(faahko_se)

## Sample group
g <- colData(faahko_se)$sample_group

## SummarizedExperiment object
plotCorr(faahko_se, i = "knn_vsn", method = "spearman", k_col = 4)

## Matrix
m <- assay(faahko_se, "knn_vsn")
plotCorr(m[1:50, ], type = "feature", method = "spearman")

}
\references{
Tal Galili, Alan O'Callaghan, Jonathan Sidi, Carson Sievert;
heatmaply: an R package for creating interactive cluster heatmaps for
online publishing, Bioinformatics, btx657,
https://doi.org/10.1093/bioinformatics/btx657
}
