% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{qsmoothPlotWeights}
\alias{qsmoothPlotWeights}
\title{Plot weights from \code{qsmooth} function.}
\usage{
qsmoothPlotWeights(
  object,
  xLab = "quantiles",
  yLab = "weights",
  mainLab = "qsmooth weights"
)
}
\arguments{
\item{object}{a qsmooth object from \code{qsmooth}}

\item{xLab}{label for x-axis. Default is "quantiles"}

\item{yLab}{label for y-axis. Default is "weights"}

\item{mainLab}{title of plot. Default is "qsmooth weights"}
}
\value{
A scatterplot will be created showing the 
\code{qsmoothWeights} along the y-axis and the 
quantiles on the x-axis.
}
\description{
This function plots a scatterplot
showing the \code{qsmoothWeights} along the y-axis
and the quantiles on the x-axis.
}
\examples{
dat <- cbind(matrix(rnorm(1000), nrow=100, ncol=10), 
             matrix(rnorm(1000, .1, .7), nrow=100, ncol=10))
dat_qs <- qsmooth(object = dat, 
                  group_factor = rep(c(0,1), each=10))
qsmoothPlotWeights(dat_qs)

}
