% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_AEI.R
\name{calc_AEI}
\alias{calc_AEI}
\title{Calculate the Adenosine Editing Index (AEI)}
\usage{
calc_AEI(
  bamfiles,
  fasta,
  alu_ranges = NULL,
  txdb = NULL,
  snp_db = NULL,
  param = FilterParam(),
  BPPARAM = SerialParam(),
  verbose = FALSE
)
}
\arguments{
\item{bamfiles}{character vector of paths to indexed bam files. If a named
character vector is supplied the names will be used in the output.}

\item{fasta}{fasta filename}

\item{alu_ranges}{\link{GRanges} with regions to query for
calculating the AEI, typically ALU repeats.}

\item{txdb}{A \link{TxDb} object, if supplied, will be used to subset the
alu_ranges to those found overlapping genes. Alternatively a \link{GRanges}
object with gene coordinates.  If the \code{library_type}, specified by
\code{FilterParam}, is \code{unstranded} then the \link{TxDb} will
be used to correct the strandness relative to the reference and is a
required
parameter.}

\item{snp_db}{either a \link{SNPlocs}, \link{GPos}, or \link{GRanges} object. If supplied,
will be used to exclude polymorphic positions prior to calculating the AEI.
If \code{calc_AEI()} will be used many times, one will save time by first
identifying SNPs that overlap the supplied \code{alu_ranges}, and passing these
as a \link{GRanges} to \code{snp_db} rather than supplying all known SNPs (see
\code{\link[=get_overlapping_snps]{get_overlapping_snps()}}).}

\item{param}{object of class \code{\link[=FilterParam]{FilterParam()}} which specify various
filters to apply to reads and sites during pileup.}

\item{BPPARAM}{A \link{BiocParallelParam} object for specifying parallel options
for operating over chromosomes.}

\item{verbose}{report progress on each chromosome?}
}
\value{
A named list containing:
\itemize{
\item \code{AEI}: a matrix of AEI index values computed for all allelic
combinations, one row for each supplied bam file.
\item \code{AEI_per_chrom}: a data.frame containing values computed for each
chromosome
}
}
\description{
The Adenosine Editing Index describes the magnitude of A-to-I
editing in a sample. The index is a weighted average of editing events (G
bases) observed at A positions. The vast majority A-to-I editing occurs in
ALU elements in the human genome, and these regions have a high A-to-I
editing signal compared to other regions such as coding exons. This
function will perform pileup at specified repeat regions and return a
summary AEI metric.
}
\examples{
suppressPackageStartupMessages(library(Rsamtools))

bamfn <- raer_example("SRR5564269_Aligned.sortedByCoord.out.md.bam")
bam2fn <- raer_example("SRR5564277_Aligned.sortedByCoord.out.md.bam")
bams <- c(bamfn, bam2fn)
names(bams) <- c("ADAR1KO", "WT")

fafn <- raer_example("human.fasta")
mock_alu_ranges <- scanFaIndex(fafn)

res <- calc_AEI(bams, fafn, mock_alu_ranges)
res$AEI

}
\references{
Roth, S.H., Levanon, E.Y. & Eisenberg, E. Genome-wide
quantification of ADAR adenosine-to-inosine RNA editing activity. Nat Methods
16, 1131–1138 (2019). https://doi.org/10.1038/s41592-019-0610-9
}
