% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawDiag.R
\name{plotScanTime}
\alias{plotScanTime}
\alias{PlotScanTime}
\title{Scan Event Plot}
\usage{
plotScanTime(x, method = "trellis")
}
\arguments{
\item{x}{a \code{data.frame} object adhering to the specified criteria for
the \code{is.rawDiag} function.}

\item{method}{specifying the plot method 'trellis' | 'violin' | 'overlay'.
The default is 'trellis'.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plotting the elapsed scan time for each individual scan event.
}
\examples{
## for debugging bioconductor check
 if (Sys.info()['sysname'] \%in\% c("Darwin", "Linux")) {Sys.which('mono')}
 rawrr::sampleFilePath() |> rawDiag::readRaw() -> S

rawDiag::checkRawrr()

S |> rawDiag::plotScanTime()
}
\references{
\itemize{
\item rawDiag: \doi{10.1021/acs.jproteome.8b00173},
\item rawrr: \doi{10.1021/acs.jproteome.0c00866}
}
}
\author{
Christian Trachsel (2017), Christian Panse (2023)
}
