% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawrr.R
\name{readFileHeader}
\alias{readFileHeader}
\title{read file header Information}
\usage{
readFileHeader(rawfile, stdout = "", stderr = "")
}
\arguments{
\item{rawfile}{the name of the raw file containing the mass spectrometry data from the Thermo Fisher Scientific instrument.}

\item{stdout, stderr}{where output to \file{stdout} or
    \file{stderr} should be sent.  Possible values are \code{""}, to the \R
    console (the default), \code{NULL} or \code{FALSE} (discard output),
    \code{TRUE} (capture the output in a character vector) or a
    character string naming a file.}
}
\value{
A list object containing the following entries: RAW file version,
Creation date, Operator, Number of instruments, Description,
Instrument model, Instrument name, Serial number, Software version,
Firmware version, Units, Mass resolution, Number of scans,
Number of ms2 scans, Scan range, Time range, Mass range,
Scan filter (first scan), Scan filter (last scan), Total number of filters,
Sample name, Sample id, Sample type, Sample comment, Sample vial,
Sample volume, Sample injection volume, Sample row number,
Sample dilution factor, or Sample barcode.
}
\description{
This function extracts the meta information from a given raw file.
}
\examples{
rawrr::sampleFilePath() |> rawrr::readFileHeader()
}
\references{
Thermo Fisher Scientific's NewRawfileReader C# code snippets
\url{https://planetorbitrap.com/rawfilereader}.
}
\author{
Tobias Kockmann and Christian Panse 2018, 2019, 2020, 2025.
}
