% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restrictFeatureMat.R
\name{restrictFeatureMat}
\alias{restrictFeatureMat}
\title{Restricts a feature matrix to only include features associated with a specified gene set.}
\usage{
restrictFeatureMat(geneSet, featureMat, prefixSet = c("cop", "exp", "mut"))
}
\arguments{
\item{geneSet}{a character vector of gene names.}

\item{featureMat}{a matrix or data frame with feature vectors along rows and feature
names specified in rownames(featureMat).}

\item{prefixSet}{a set of feature name prefixes to be prepended to each element of geneSet to 
obtain a collection of geneSet-associated features.}
}
\value{
a matrix containing the features in the intersection of rownames(featureMat) and
the set of geneSet-derived features (obtained by prepending each element of prefixSet to 
each gene in geneSet).

#' @examples 
X <- matrix(1:25, nrow=5)
rownames(X) <- c("expA", "expB", "copC", "mutC", "expD")
restrictFeatureMat(geneSet = c("B", "C"), X)
}
\description{
Restricts a feature matrix to only include features associated with a specified gene set.
}
\concept{rcellminer}
