% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate_url.R
\name{locate_url}
\alias{locate_url}
\title{Construct the URL to access a particular \code{recount3} file}
\usage{
locate_url(
  project,
  project_home = project_homes(organism = organism, recount3_url = recount3_url),
  type = c("metadata", "gene", "exon", "jxn", "bw"),
  organism = c("human", "mouse"),
  sample = NULL,
  annotation = annotation_options(organism),
  jxn_format = c("ALL", "UNIQUE"),
  recount3_url = getOption("recount3_url", "http://duffel.rail.bio/recount3")
)
}
\arguments{
\item{project}{A \code{character(1)} with the ID for a given study.}

\item{project_home}{A \code{character(1)} with the home directory for the
\code{project}. You can find these using \code{project_homes()}.}

\item{type}{A \code{character(1)} specifying whether you want to access gene
counts, exon counts, exon-exon junctions or base-pair BigWig coverage files
(one per \code{sample}).}

\item{organism}{A \code{character(1)} specifying which organism you want to
download data from. Supported options are \code{"human"} or \code{"mouse"}.}

\item{sample}{A \code{character()} vector with the sample ID(s) you want to
download.}

\item{annotation}{A \code{character(1)} specifying which annotation you want to
download. Only used when \code{type} is either \code{gene} or \code{exon}.}

\item{jxn_format}{A \code{character(1)} specifying whether the exon-exon junction
files are derived from all the reads (\code{ALL}) or only the uniquely mapping
read counts (\code{UNIQUE}). Note that \code{UNIQUE} is only available for some
projects: GTEx and TCGA for human.}

\item{recount3_url}{A \code{character(1)} specifying the home URL for \code{recount3}
or a local directory where you have mirrored \code{recount3}. Defaults to the
load balancer \url{http://duffel.rail.bio/recount3}, but can also be
\url{https://recount-opendata.s3.amazonaws.com/recount3/release} from
\url{https://registry.opendata.aws/recount/} or from
IDIES at JHU \url{https://idies.jhu.edu/recount3/data} (which redirects to
\url{https://data.idies.jhu.edu/recount3/data/}). You can
set the R option \code{recount3_url} (for example in your \code{.Rprofile}) if
you have a favorite mirror.}
}
\value{
A \code{character()} with the URL(s) for the file(s) of interest.
}
\description{
Given an organism of interest, this function constructs the URL for accessing
one of the output files from the \code{recount3} project. You can then download
the file using \code{file_retrieve()}.
}
\examples{

## Example for metadata files from a project from SRA
locate_url(
    "SRP009615",
    "data_sources/sra"
)

## Example for metadata files from a project that is part of a collection
locate_url(
    "ERP110066",
    "collections/geuvadis_smartseq",
    recount3_url = "http://snaptron.cs.jhu.edu/data/temp/recount3"
)

## Example for a BigWig file
locate_url(
    "SRP009615",
    "data_sources/sra",
    "bw",
    "human",
    "SRR387777"
)

## Locate example gene count files
locate_url(
    "SRP009615",
    "data_sources/sra",
    "gene"
)
locate_url(
    "SRP009615",
    "data_sources/sra",
    "gene",
    annotation = "refseq"
)

## Example for a gene count file from a project that is part of a collection
locate_url(
    "ERP110066",
    "collections/geuvadis_smartseq",
    "gene",
    recount3_url = "http://snaptron.cs.jhu.edu/data/temp/recount3"
)

## Locate example junction files
locate_url(
    "SRP009615",
    "data_sources/sra",
    "jxn"
)

## Example for metadata files from a project from SRA
locate_url(
    "ERP001942",
    "data_sources/sra"
)
}
\seealso{
Other internal functions for accessing the recount3 data: 
\code{\link{annotation_ext}()},
\code{\link{create_rse_manual}()},
\code{\link{file_retrieve}()},
\code{\link{locate_url_ann}()},
\code{\link{project_homes}()},
\code{\link{read_counts}()},
\code{\link{read_metadata}()}
}
\concept{internal functions for accessing the recount3 data}
