% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_retry.R
\name{download_retry}
\alias{download_retry}
\title{Retry multiple times to download a file}
\usage{
download_retry(url, destfile = basename(url), mode = "wb", N.TRIES = 3L, ...)
}
\arguments{
\item{url}{The URL to download. Passed to \link[downloader:download]{download}.}

\item{destfile}{The destination file. Defaults to the base name of the URL.
Passed to \link[downloader:download]{download}.}

\item{mode}{Mode for writing the file. The default \code{wb} is used for
binary files. This value is passed to \link[downloader:download]{download} which
passes it to \link[utils:download.file]{download.file}.}

\item{N.TRIES}{The number of download attempts before giving up; default: 3.
Should be an integer of length one with a value greater than 0.}

\item{...}{Additional arguments passed to \link[downloader:download]{download}.}
}
\value{
An invisible integer code as specified in
\link[utils:download.file]{download.file}.
}
\description{
This function is based on the Bioconductor guidelines for querying data from
the web at \url{http://bioconductor.org/developers/how-to/web-query/}. It
will run \link[downloader:download]{download} a set of \code{N.TRIES} times before
giving up. We implemented this function to reduce the number of Bioconductor
build errors due to the occassional errors from our data hosting server.
}
\examples{

## Download the first files_info.tsv file (version 1)
download_retry(
    recount_url$url[which(recount_url$file_name == "files_info.tsv")[1]]
)
}
