% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnam_search_index.R
\name{get_fh}
\alias{get_fh}
\title{get_fh}
\usage{
get_fh(csv_savepath, csv_openpath, ndim = 1000, lstart = 1)
}
\arguments{
\item{csv_savepath}{Name/path of hashed features table to write (required,
string, writes new csv where rows = samples, cols = hashed features).}

\item{csv_openpath}{Name/path of table to hash (required, string, assumes 
a csv where rows = samples, cols = probes).}

\item{ndim}{Number of hashed features (integer, 1000).}

\item{lstart}{Line index to start on (0-based for Python, required, int, 0).}
}
\value{
Path to new hashed featuers table.
}
\description{
Get the hashed features for a data table. Uses reticulate package to
call the Python script to do feature hashing on a table of data. It is
assumed the input table has sample data in rows, with probe data in 
columns. The input data table should have row names but not column names.
}
\examples{
# get example bval csv
# of_fpath <- system.file("extdata", "fhtest", 
#        package = "recountmethylation")
# of_fpath <- file.path(of_fpath, "tbval_test.csv")
# write new hashed features results
# get_fh(csv_savepath = "bval_fn.csv", csv_openpath = of_fpath, ndim = 100)
}
