% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{rgse}
\alias{rgse}
\title{Form an RGChannelSet from a list containing signal data matrices}
\usage{
rgse(ldat, verbose = FALSE)
}
\arguments{
\item{ldat}{List of raw signal data query results. Must include 2 
data.frame objects named "redsignal" and "greensignal."}

\item{verbose}{Whether to post status messages.}
}
\value{
Returns a RGChannelSet object from raw signal dataset queries.
}
\description{
Forms an RGChannelSet from signal data list. This is called by 
certain queries to h5 files.
}
\examples{
path <- system.file("extdata", "h5test", package = "recountmethylation")
fn <- list.files(path)
dbpath <- file.path(path, fn)
rg <- getrg(dbn = dbpath, all.gsm = TRUE, metadata = FALSE)
dim(rg) # [1] 11162     2
class(rg)
# [1] "RGChannelSet"
# attr(,"package")
# [1] "minfi"
}
\seealso{
getrg(), RGChannelSet()
}
