% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseHclustMet.R
\name{chooseHclustMet}
\alias{chooseHclustMet}
\title{chooseHclustMet}
\usage{
chooseHclustMet(GM, scale = FALSE, vecMet = NULL, distHC = "euclidean")
}
\arguments{
\item{GM}{matrix,  numerical matrix.}

\item{scale}{logical, if TRUE, the clustering will be performed using the scaled matrix. (default = FALSE)}

\item{vecMet}{character, vector of methods that will be tested in the function.
If NULL, the following methods will be tested: "complete", "average", "single", "ward.D2", "median", "centroid" and "mcquitty. (default = NULL)}

\item{distHC}{character, the distance measure to be used from those available in \code{\link[=dist]{dist()}} . (default = "euclidean")}
}
\value{
An object of class \link{hclust}
}
\description{
Evaluate and choose the best method for clustering a matrix using the \code{\link[=hclust]{hclust()}} function.
}
\examples{

M1 <- matrix(1:18, nrow = 6, ncol = 3)
set.seed(42)
M2 <- matrix(sample(100, 18), nrow = 6, ncol = 3)
GM <- cbind(M1, M2)

chooseHclustMet(GM)


}
\seealso{
\code{\link[=hclust]{hclust()}}
}
