% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCrosswiseMatrix.R
\name{makeCrosswiseMatrix}
\alias{makeCrosswiseMatrix}
\title{makeCrosswiseMatrix}
\usage{
makeCrosswiseMatrix(mPT, clusterize = TRUE, hc.method = NULL, dist.method = "euclidean",
transform = FALSE, scale = FALSE, zs.type = 'norm_zscore', symm_matrix = TRUE,
selectRow = NULL, selectCol = NULL, pvcut = 1, subEX = 0, GM_diag = TRUE, ...)
}
\arguments{
\item{mPT}{an object of class \link[=genoMatriXeR-class]{genoMatriXeR}.}

\item{clusterize}{logical, if TRUE the matrix will be clustered using the method specified by \code{hc.method} (default = TRUE)}

\item{hc.method}{character, select the \code{\link[=hclust]{hclust()}} method to use for clustering the matrix. If NULL, the clustering method will be automatically selected by the function \code{\link[=chooseHclustMet]{chooseHclustMet()}}. (default = NULL)}

\item{dist.method}{character, the distance measure to be used from those available in \code{\link[=dist]{dist()}} . (default = "euclidean")}

\item{transform}{logical, if TRUE the matrix will be transformed using the function \code{\link[=t]{t()}}. (default = FALSE)}

\item{scale}{logical, if TRUE the matrix will be scaled. (default = FALSE)}

\item{zs.type}{character, z-score type to use to generate the matrix, either raw z-score ("zscore") or normalized z-score ("norm_zscore"). (default = "norm_zscore")}

\item{symm_matrix}{logical, if TRUE the matrix will be treated as symmetrical (same clustering for rows and columns). (default = TRUE)}

\item{selectRow, selectCol}{vector, the matrix will be reduced selecting the rows and/or columns in this vector. (default = NULL)}

\item{pvcut}{numeric, the z-score value is substituted by \code{subEX} (0 by default) for all the associations with an adj.pvalue (as calculated in \code{\link[=crosswisePermTest]{crosswisePermTest()}}) higher than \code{pvcut}. (default = 0.05)}

\item{subEX}{numeric, value used to substitute the z-score values when the associated pvalue is higher than \code{pvcut}. (default = 0)}

\item{GM_diag}{logic, if FALSE the values of the diagonal will be set to 0. (default = TRUE)}

\item{...}{further arguments to be passed to other methods.}
}
\value{
An object of class \link[=genoMatriXeR-class]{genoMatriXeR} containing three slots, with a populated \code{matrix} slot.

\itemize{
\item \bold{\code{@parameters}}
\item \bold{\code{@multioverlaps}}
\item \bold{\code{@matrix}}

}
}
\description{
Populate the \code{matrix} slot in a \link[=genoMatriXeR-class]{genoMatriXeR} object.
}
\details{
This function will create a series of matrices of z-scores, adj.pvalues and
pearson correlation values from all the pairwise permutation tests stored in
the \code{multiOverlaps} slot of a \link[=genoMatriXeR-class]{genoMatriXeR} as
calculated with \code{\link[=multiPermTest]{multiPermTest()}}. These matrices will then be stored in the
\code{matrix} slot of the \link[=genoMatriXeR-class]{genoMatriXeR} object. In addition,
clustering will be performed on the association matrices using \link{hclust}.
}
\examples{

data("cw_Alien")

cw_Alien_ReG <- makeCrosswiseMatrix(cw_Alien_ReG)

summary(cw_Alien_ReG)

}
\seealso{
\code{\link[=crosswisePermTest]{crosswisePermTest()}}, \code{\link[=chooseHclustMet]{chooseHclustMet()}}, \code{\link[=plotCrosswiseMatrix]{plotCrosswiseMatrix()}}
}
