% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSingleLZ.R
\name{plotSingleLZ}
\alias{plotSingleLZ}
\title{plotSingleLZ}
\usage{
plotSingleLZ(mLZ, RS, xlab = "", normZS = TRUE, ylim = NULL, main = NA,
 colPal = NULL, labValues = TRUE, labSize = 2.5, labMax = FALSE, smoothing = FALSE, ...)
}
\arguments{
\item{mLZ}{an object of class \link[=multiLocalZScore-class]{multiLocalZScore}.}

\item{RS}{character, vector of region set names for which to plot the local Z-score results.}

\item{xlab}{character, label for the x axis. (default = NA)}

\item{normZS}{logical, indicates whether the normalized Z-score values should be plotted. If FALSE, the raw Z-score is used. (default = TRUE)}

\item{ylim}{numeric, vector with two elements: minimum and maximum Y values of the plot. If NULL, the plot limits are set by default so all data points can be plotted. (default = NULL)}

\item{main}{character, title for the plot. If NA, the name of the query region set in the multiLocalZScore object will be used. (default = NA)}

\item{colPal}{character, colors to use as palette for the plot. If NULL, default colors will be used. (default = NULL)}

\item{labValues}{logical, if TRUE each local Z-score profile is labelled at position 0 with the name of the region set and its Z-score value at the central position. (default = TRUE)}

\item{labSize}{numerical, size of the labels from labValues in the plot. (default = 2.5)}

\item{labMax}{logical, if TRUE the labels are placed at the maximum value of each local Z-score profile instead of the center. (default = FALSE)}

\item{smoothing}{logical, if TRUE the \code{\link[=smooth.spline]{smooth.spline()}} function will be applied to the localZ-score profile. (default = FALSE)}

\item{...}{further arguments to be passed to other methods.}
}
\value{
Returns a ggplot object.
}
\description{
Plot the result of specific local Z-Score tests from a \link[=multiLocalZScore-class]{multiLocalZScore} object in the
form of line plot profiles.
}
\details{
This function generates a line plot with the local Z-score profiles of
selected region sets from a \link[=multiLocalZScore-class]{multiLocalZScore} object. This type of plot
complements the local Z-score matrix (generated by \link{plotLocalZScoreMatrix},
since it allows to visualize in detail the local Z-score profile of just the
region sets of interest.

This plot is well suited for a single or a few region sets, but
will get busy if attempting to plot many different profiles. For the latter,
the full matrix generated by \link{plotLocalZScoreMatrix} is usually a better
visualization option.
}
\examples{

data("cw_Alien")

plotSingleLZ(mLZ_regA_ReG, RS = c("regD", "regD_02", "regA", "regAB_04"),
labMax = TRUE, smoothing = TRUE)

}
\seealso{
\code{\link[=multiLocalZscore]{multiLocalZscore()}}, \code{\link[=makeLZMatrix]{makeLZMatrix()}}
}
