% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dna_objects.R
\name{get_dna_objects}
\alias{get_dna_objects}
\title{Retrieve genomic elements from regulonDB}
\usage{
get_dna_objects(
  regulondb,
  genome = "eschColi_K12",
  grange = GRanges("chr", IRanges(1, 5000)),
  elements = "gene"
)
}
\arguments{
\item{regulondb}{A \code{\link[=regulondb]{regulondb()}} object.}

\item{genome}{A valid UCSC genome name.}

\item{grange}{A \code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges-class()}} object indicating position
left and right.}

\item{elements}{A character vector specifying which annotation elements to
plot. It can be any from: \code{"-10 promoter box"}, \code{"-35 promoter box"},
\code{"gene"}, \code{"promoter"}, \code{"Regulatory Interaction"}, \code{"sRNA interaction"},
or \code{"terminator"}.}
}
\value{
\code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges-class()}} object with the elements found.
}
\description{
Retrieve genomic elements from regulonDB
}
\examples{
## Connect to the RegulonDB database if necessary
if (!exists("regulondb_conn")) {
      regulondb_conn <- connect_database()
  }

## Build the regulondb object
e_coli_regulondb <-
    regulondb(
        database_conn = regulondb_conn,
        organism = "chr",
        database_version = "1",
        genome_version = "1"
    )

## Get all genes from E. coli
get_dna_objects(e_coli_regulondb)

## Get genes providing Genomic Ranges
grange <- GenomicRanges::GRanges(
    "chr",
    IRanges::IRanges(5000, 10000)
)
get_dna_objects(e_coli_regulondb, grange)

## Get aditional elements within genomic positions
get_dna_objects(e_coli_regulondb,
    grange,
    elements = c("gene", "promoter")
)
}
\author{
Joselyn Chavez
}
