% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_AllClasses.R, R/02_plot.R,
%   R/mExWAS-extract.R, R/mExWAS-plotExwas.R
\docType{class}
\name{mExWAS}
\alias{mExWAS}
\alias{mExWAS-class}
\alias{plot,mExWAS,ANY-method}
\alias{extract,mExWAS-method}
\alias{plotExwas,mExWAS-method}
\title{Class mExWAS}
\usage{
\S4method{plot}{mExWAS,ANY}(x, y, ...)

\S4method{extract}{mExWAS}(object, type = "test", sort = TRUE)

\S4method{plotExwas}{mExWAS}(
  object,
  ...,
  subtitles,
  color,
  exp.order,
  labels,
  show.effective = TRUE
)
}
\arguments{
\item{x}{Object of class \code{mExWAS}}

\item{y}{NOT USED}

\item{...}{Other used arguments.}

\item{object}{object of class \code{mExWAS}.}

\item{type}{(default \code{"test"}). Can take \code{"test"} or \code{"raw"}
to obtain a \code{data.frame} of \code{glmnet} result.}

\item{sort}{NOT USED}

\item{subtitles}{NOT USED}

\item{color}{NOT USED}

\item{exp.order}{NOT USED}

\item{labels}{NOT USED}

\item{show.effective}{NOT USED}
}
\value{
An object of class \code{mExWAS}
}
\description{
Class \code{mExWAS} obtained from \link{mexwas} method of an
\link{ExposomeSet} object, contains the result of testing the multiple
models of exposures of an \code{ExposomeSet} to a set of given phenotypes.
"mExWAS" is the #' acronym of "Multivariate Exposome-Wide Association
Study".
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot(x = mExWAS, y = ANY)}: Wrapper for \code{plotExwas} method.

\item \code{extract(mExWAS)}: Method to obtain the generated model

\item \code{plotExwas(mExWAS)}: Method to plot a heap-map with the coeficient of each
exposure

}}
\section{Slots}{

\describe{
\item{\code{result}}{klist with the fitted model and result.}

\item{\code{phenotype}}{Name of the phenotype used in the analysys.}

\item{\code{description}}{feature data from original ExposomeSet.}
}}

\seealso{
\code{\link{mexwas}} to perform a Multivariate Exposome-Wide
Association Study and to create a \code{\link{mExWAS}},
\code{\link{exwas}} to perform an Exposome-Wide  Association Study
and to create an \code{\link{ExWAS}}
}
