% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{plotPCA}
\alias{plotPCA}
\title{Ploting PCA}
\usage{
plotPCA(
  object,
  set,
  cmpX = 1,
  cmpY = 2,
  show.exposures = FALSE,
  show.samples = FALSE,
  phenotype
)
}
\arguments{
\item{object}{An onbject of class \link{ExposomePCA}}

\item{set}{Group (\code{"all"}, \code{"samples"} or \code{"exposures"})
taht will be ploted.}

\item{cmpX}{(default: \code{1}) component to be placed at X axis}

\item{cmpY}{(default: \code{2}) component to be placed at Y axis}

\item{show.exposures}{(default: \code{FALSE}) If set to true, labels indicating
the exposures are shown.}

\item{show.samples}{(default: \code{FALSE}) If set to true, labels indicating
the samples are shown.}

\item{phenotype}{If \code{set} is set to \code{"samples"} can be used to
color samples by phenotype}
}
\value{
An object of class \code{ggplot} or an object of class
\code{gtable} if argument \code{set} was set to \code{"all"}.
}
\description{
Methdo to draw a plot for PCA contained in an \link{ExposomePCA}
}
\examples{
data("exposome")
epca <- pca(expo[3:7, 1:100])
# A grid with exposures space, samples space and explained variance
plotPCA(epca, set = "all")
# Only exposures space
plotPCA(epca, set = "exposures") + ggplot2::theme(legend.position = "bottom")
# Only samples space
plotPCA(epca, set = "samples")
# Only samples space but coloured by phenotype
plotPCA(epca, set = "samples", phenotype = "sex") +
ggplot2::theme(legend.position = "bottom")
}
\seealso{
\link{pca} to compite PCA on an \link{ExposomeSet}, \link{plotPCA}
to plot the PCA, \link{ExposomePCA} as main class
}
