% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5F.R
\name{H5Fget_intent}
\alias{H5Fget_intent}
\title{Determine the read only or read/write status of an open file handle.}
\usage{
H5Fget_intent(h5file)
}
\arguments{
\item{h5file}{An object of class \linkS4class{H5IdComponent} representing a H5
file identifier.  Typically produced by \code{\link[=H5Fopen]{H5Fopen()}} or \code{\link[=H5Fcreate]{H5Fcreate()}}.}
}
\value{
Returns a character vector of length 1.  This will either be \code{H5F_ACC_RDWR} (read / write)
or \code{H5F_ACC_READONLY} (read only).
}
\description{
Determine the read only or read/write status of an open file handle.
}
\details{
The native \code{H5Fget_intent()} function can in theory also return the values \code{H5F_ACC_SWMR_WRITE}
and \code{H5F_ACC_SWMR_READ}.  However these require the underlying HDF5 library to be complied with
support for single-writer/multiple-reader (SWMR), which Rhdf5lib currently is not.  Hence only the two
values detailed in the values section should be possible.
}
\examples{

## use an example file and show its location
h5file <- system.file("testfiles", "h5ex_t_array.h5", package = "rhdf5")
## open the file as read only and check this
fid <- H5Fopen(h5file, flags = "H5F_ACC_RDONLY")
H5Fget_intent(fid)
H5Fclose(fid)

## open file as read write and confirm
fid <- H5Fopen(h5file, flags = "H5F_ACC_RDWR")
H5Fget_intent(fid)
H5Fclose(fid)

}
