% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5ls.R
\name{h5ls}
\alias{h5ls}
\title{List the content of an HDF5 file.}
\usage{
h5ls(
  file,
  recursive = TRUE,
  all = FALSE,
  datasetinfo = TRUE,
  index_type = h5default("H5_INDEX"),
  order = h5default("H5_ITER"),
  s3 = FALSE,
  s3credentials = NULL,
  native = FALSE
)
}
\arguments{
\item{file}{The filename (character) of the file in which the dataset will
be located. You can also provide an object of class \linkS4class{H5IdComponent}
representing a H5 location identifier (file or group). See \code{\link[=H5Fcreate]{H5Fcreate()}},
\code{\link[=H5Fopen]{H5Fopen()}}, \code{\link[=H5Gcreate]{H5Gcreate()}}, \code{\link[=H5Gopen]{H5Gopen()}} to create an object of this kind.}

\item{recursive}{If \code{TRUE}, the content of the whole group hierarchy is
listed. If \code{FALSE}, Only the content of the main group is shown. If a positive
integer is provided this indicates the maximum level of the hierarchy that
is shown.}

\item{all}{If \code{TRUE}, a longer list of information on each entry is provided.}

\item{datasetinfo}{If \code{FALSE}, datatype and dimensionality information is not
provided. This can speed up the content listing for large files.}

\item{index_type}{See \code{h5const("H5_INDEX")} for possible arguments.}

\item{order}{See \code{h5const("H5_ITER")} for possible arguments.}

\item{s3}{Logical value indicating whether the file argument should be
treated as a URL to an Amazon S3 bucket, rather than a local file path.}

\item{s3credentials}{A list of length three, providing the credentials for
accessing files in a private Amazon S3 bucket.}

\item{native}{An object of class \code{logical}. If TRUE, array-like objects
are treated as stored in HDF5 row-major rather than R column-major
orientation. Using \code{native = TRUE} increases HDF5 file portability
between programming languages. A file written with \code{native = TRUE}
should also be read with \code{native = TRUE}}
}
\value{
\code{h5ls} returns a \code{data.frame} with the file content.
}
\description{
List the content of an HDF5 file.
}
\examples{

h5File <- tempfile(pattern = "ex_dump.h5")
h5createFile(h5File)

# create groups
h5createGroup(h5File, "foo")
h5createGroup(h5File, "foo/foobaa")

# write a matrix
B <- array(seq(0.1, 2.0, by = 0.1), dim = c(5, 2, 2))
attr(B, "scale") <- "liter"
h5write(B, h5File, "foo/B")

# list content of hdf5 file
h5ls(h5File, all = TRUE)

# list content of an hdf5 file in a public S3 bucket
\donttest{
h5ls(file = "https://rhdf5-public.s3.eu-central-1.amazonaws.com/h5ex_t_array.h5", s3 = TRUE)
}

}
\references{
\url{https://portal.hdfgroup.org/display/HDF5}
}
\seealso{
\code{\link[=h5dump]{h5dump()}}
}
\author{
Bernd Fischer, Mike L. Smith
}
\keyword{IO}
\keyword{file}
\keyword{interface}
\keyword{programming}
