% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_AddMetaData.R
\name{AddMetaData}
\alias{AddMetaData}
\title{Add metadata columns to GRanges object.}
\usage{
AddMetaData(
  target_gr,
  annot_gr = NULL,
  annotType_char = c("geneSymbol", "region"),
  annotLabel_char = "symbol",
  genome = c("hg38", "hg19")
)
}
\arguments{
\item{target_gr}{A GRanges object that will be annotated with metadata}

\item{annot_gr}{A GRanges object that includes the metadata
information. When \code{annotType_char} = \code{"geneSymbol"}, this 
argument can be left as NULL, and the gene annotation file saved in the 
package will be used to annotate \code{target_gr}. When 
\code{annotType_char} = \code{"region"}, this argument must be specified, 
each row in \code{target_gr} will be annotated with rows in 
\code{annot_gr} that overlap with it.}

\item{annotType_char}{Type of the metadata column, defaults to
\code{"geneSymbol"}.}

\item{annotLabel_char}{Name of the metadata column, defaults to 
\code{"symbol"} which corresponds to default setting \code{"geneSymbol"} 
for argument \code{annotType_char}.}

\item{genome}{Use \code{"hg19"} or \code{"hg38"} gene reference. Defaults 
to \code{"hg38"}.}
}
\value{
A GRanges object with \code{seqnames, ranges, region}, and supplied
  metadata information.
}
\description{
Add metadata information to GRanges object.
}
\examples{
  data(rnaedit_df)
  
  input_gr <- TransformToGR(
    genes_char = "PHACTR4",
    type = "symbol",
    genome = "hg19"
  )
 
  # identifies co-edited region within input_gr 
  coedited_gr <- AllCoeditedRegions(
    regions_gr = input_gr,
    rnaEditMatrix = rnaedit_df,
    output = "GRanges",
    method = "spearman"
  )
  
  # identify input regions for co-edited regions
  AddMetaData(
    target_gr = coedited_gr,
    annot_gr = input_gr,
    annotType_char = "region",
    annotLabel_char = "inputRegion",
    genome = "hg19"
  )
  
}
\keyword{internal}
