% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocess}
\alias{preprocess}
\title{Preprocess input data with Principal Component Analysis method (PCA)}
\usage{
preprocess(
  data,
  pheno = NULL,
  method = "pca",
  reg.family = "binomial",
  scaleData = FALSE,
  cumvar.threshold = 75,
  out.type = "D",
  penalty = 0.001,
  verbose = FALSE
)
}
\arguments{
\item{data}{An input matrix with values of 
independent variables (predictors).}

\item{pheno}{A phenotype - column-vector, needed for LASSO/ridge and 
\code{NULL} by default.}

\item{method}{A dimensionality reduction method.
Default: \code{pca}.}

\item{reg.family}{A regression family. 
Default: \code{"binomial"}.}

\item{scaleData}{A logical variable, indicates wheither or 
not scaling should be performed. Default: \code{FALSE}.}

\item{cumvar.threshold}{A threshold value for explained variance.
Default: \code{75}}

\item{out.type}{An output (phenotype) type. 
Default: \code{"D"}}

\item{penalty}{Value of penalty parameter for LASSO/ridge regression. 
Default: \code{0.001}}

\item{verbose}{Indicates verbosing output. Default: FALSE.}
}
\value{
A list of one: "S" - a data frame of predictor values.
}
\description{
Preprocess input data with Principal Component Analysis method (PCA)
}
