% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize_predicates}
\alias{summarize_predicates}
\title{Summarize predicates}
\usage{
summarize_predicates(graph, object, print = TRUE)
}
\arguments{
\item{graph}{The SemMed graph}

\item{object}{A vertex sequence (\code{igraph.vs}), a list of vertex
sequences, or a list of vertex sequence lists}

\item{print}{If \code{TRUE}, information on predicates will be 
printed to the screen.}
}
\value{
A \code{tbl} where each row corresponds to a 
\code{from}-\code{to} pair in \code{object}. The last column is a
list-column containing \code{table}'s of predicate counts.
}
\description{
Summarize the predicates present in a collection of paths
}
\details{
Because predicates are edge features, it is assumed that by using
\code{summarize_predicates} the nodes contained in \code{object} are 
ordered (paths). This is why \code{summarize_semtypes} has the 
\code{is_path} argument, but \code{summarize_predicates} does not.
\code{summarize_predicates} tabulates edge predicates across paths 
corresponding to each \code{from}-\code{to} pair in \code{object}.
}
\examples{
data(g_mini)

node_cortisol <- find_nodes(g_mini, "Serum cortisol")
node_stress <- find_nodes(g_mini, "Chronic Stress")
paths <- find_paths(g_mini, from = node_cortisol, to = node_stress)
summarize_predicates(g_mini, paths)

}
\seealso{
\code{\link{summarize_semtypes}} for tabulating 
semantic types of nodes in paths or other node collections
}
