% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{sracipeConvergeDist}
\alias{sracipeConvergeDist}
\alias{sracipeConvergeDist,RacipeSE-method}
\title{A method to visualize convergence distributions}
\usage{
sracipeConvergeDist(.object, plotToFile = FALSE)

\S4method{sracipeConvergeDist}{RacipeSE}(.object, plotToFile = FALSE)
}
\arguments{
\item{.object}{RacipeSE object generated by \code{\link{sracipeSimulate}}
function.}

\item{plotToFile}{(optional) logical. Default \code{FALSE}. Whether to save
plots to a file.}
}
\value{
\code{RacipeSE} object
}
\description{
When convergence tests are done (deterministic systems with time
series off), this method creates a plot of the proportion of converged initial
conditions as the number of convergence tests increases, up to the total number
done by the simulation. Note that when limit cycles are detected, they are
automatically removed from consideration. This method also adds some statistics to the
metadata of the input. Models with NaN values are also removed.
Specifically, the final proportion of converged states
is reported, and if it exists, the smallest number of convergence tests where
at least 99 percent of models converged is also reported.
}
\section{Related Functions}{


\code{\link{sracipeSimulate}},  \code{\link{sracipeKnockDown}},
\code{\link{sracipeOverExp}},  \code{\link{sracipePlotData}}
}

\examples{
data("demoCircuit")
\dontrun{
rSet <- sRACIPE::sracipeSimulate(circuit = demoCircuit, numModels = 20,
integrateStepSize = 0.1, numConvergenceIter = 30)
rSet <- sracipeConvergeDist(rSet)
}
}
