test_that("'getProcessors' test", {
    expect_equal(getProcessors(1), 1)
})

test_that("'alignContigs' function test", {
    contigList <- sangerAlignment@contigList
    geneticCode <- sangerAlignment@geneticCode
    refAminoAcidSeq <- sangerAlignment@refAminoAcidSeq
    minFractionCallSA <- sangerAlignment@contigList[[1]]@minFractionCall
    maxFractionLostSA <- sangerAlignment@contigList[[1]]@maxFractionLost
    alignContigs <- alignContigs (contigList, geneticCode,
                                  refAminoAcidSeq, minFractionCallSA,
                                  maxFractionLostSA, 1)
    expect_equal(length(alignContigs$aln), 4)
    expect_equal(as.character(alignContigs$consensus), "TTATAYTTTATTYTRGGCGTCTGAGCAGGAATGGTTGGAGCYGGTATAAGACTYCTAATTCGAATYGAGCTAAGACARCCRGGAGCRTTCCTRGGMAGRGAYCAACTMTAYAATACTATYGTWACTGCWCACGCATTTGTAATAATYTTCTTTCTAGTAATRCCTGTATTYATYGGGGGRTTCGGWAAYTGRCTTYTACCTTTAATACTTGGAGCCCCYGAYATRGCATTCCCWCGACTYAACAACATRAGATTCTGACTMCTTCCCCCATCACTRATCCTTYTAGTGTCCTCTGCKGCRGTAGAAAAAGGCGCTGGWACKGGRTGAACTGTTTATCCGCCYCTAGCAAGAAATMTTGCYCAYGCMGGCCCRTCTGTAGAYTTAGCYATYTTTTCYCTTCATTTAGCGGGTGCKTCWTCWATYYTAGGGGCYATTAATTTTATYACYACWGTTATTAAYATGCGWTGAAGAGGMTTACGWCTTGAACGAATYCCMYTRTTYGTYTGAGCYGTRCTAATTACAGTKGTTCTTCTACTYCTATCYTTACCAGTGYTAGCMGGTGCMATTACYATACTWCTTACCGAYCGAAAYCTCAATACYTCMTTCTTTGATCCTGCYGGTGGTGGAGAYCCCATCCTCTACCAACACTTATTCTGATTTTTTGGTCACCCTGAG")
    expect_equal(as.character(alignContigs$aln[[1]]), "TTATATTTTATTCTGGGCGTCTGAGCAGGAATGGTTGGAGCCGGTATAAGACTTCTAATTCGAATCGAGCTAAGACAACCAGGAGCGTTCCTGGGCAGAGACCAACTATACAATACTATCGTTACTGCACACGCATTTGTAATAATCTTCTTTCTAGTAATGCCTGTATTCATCGGGGGATTCGGAAACTGGCTTTTACCTTTAATACTTGGAGCCCCCGATATAGCATTCCCTCGACTCAACAACATGAGATTCTGACTACTTCCCCCATCACTGATCCTTTTAGTGTCCTCTGCGGCGGTAGAAAAAGGCGCTGGTACGGGGTGAACTGTTTATCCGCCTCTAGCAAGAAATCTTGCCCACGCAGGCCCGTCTGTAGATTTAGCCATCTTTTCCCTTCATTTAGCGGGTGCGTCTTCTATTCTAGGGGCTATTAATTTTATCACCACAGTTATTAATATGCGTTGAAGAGGATTACGTCTTGAACGAATTCCCCTGTTTGTCTGAGCTGTGCTAATTACAGTTGTTCTTCTACTTCTATCTTTACCAGTGCTAGCAGGTGCCATTACCATACTTCTTACCGACCGAAACCTCAATACTTCATTCTTTGATCCTGCCGGTGGTGGAGACCCCATCCTC------------------------------------")
    expect_equal(as.character(alignContigs$aln[[2]]), "---------------------TGAGCAGGAATGGTTGGAGCCGGTATAAGACTTCTAATTCGAATCGAGCTAAGACAACCAGGAGCGTTCCTGGGCAGAGACCAACTATACAATACTATCGTTACTGCACACGCATTTGTAATAATCTTCTTTCTAGTAATGCCTGTATTCATCGGGGGATTCGGAAACTGGCTTTTACCTTTAATACTTGGAGCCCCCGATATAGCATTCCCTCGACTCAACAACATGAGATTCTGACTACTTCCCCCATCACTGATCCTTTTAGTGTCCTCTGCGGCGGTAGAAAAAGGCGCTGGTACGGGGTGAACTGTTTATCCGCCTCTAGCAAGAAATCTTGCCCACGCAGGCCCGTCTGTAGATTTAGCCATCTTTTCCCTTCATTTAGCGGGTGCGTCTTCTATTCTAGGGGCTATTAATTTTATCACCACAGTTATTAATATGCGTTGAAGAGGATTACGTCTTGAACGAATTCCCCTGTTTGTCTGAGCTGTGCTAATTACAGTTGTTCTTCTACTTCTATCTTTACCAGTGCTAGCAGGTGCCATTACCATACTTCTTACCGACCGAAACCTCAATACTTCATTCTTTGATCCTGCCGGTGGTGGAGACCCCATCCTCTACCAACACTTATTCTGATTTTTTGGTCACCCTGAG")
    expect_equal(as.character(alignContigs$aln[[3]]), "------------------------------------GGGGCTGGTATAAGACTCCTAATTCGAATTGAGCTAAGACAGCCGGGAGCATTTCTAGGAAGGGATCAACTCTATAACACTATTGTAACTGCTCACGCATTTGTAATAATTTTCTTTCTAGTAATACCTGTATTTATTGGGGGGTTCGGTAATTGACTTCTACCTTTAATACTTGGAGCCCCTGACATGGCATTCCCACGTCTTAACAACATAAGATTTTGACTCCTTCCCCCATCACTAATCCTTCTAGTATCCTCTGCTGCAGTAGAAAAGGGGGCGGGAACTGGATGAACTGTTTATCCGCCCCTAGCAAGAAATATTGCTCATGCCGGCCCATCTGTAGACTTAGCTATTTTTTCTCTTCATTTAGCAGGTGCTTCATCAATCTTGGGTGCCATTAATTTTATTACTACTGTTATTAACATACGATGAAGAGGCTTACGACTTGAGCGAATCCCATTATTCGTTTGAGCCGTACTAATTACAGTGGTCCTTCTACTCTTATCCTTACCAGTATTAGCCGGTGCAATTACTATACTACTTACCGATCGAAATCKWAAWWMCYYCTTCTTTGATCCTGCTGGAGGTGGAGATCCAATCCTATACCAACACTTATTCTGATTTTTT------------")
    expect_equal(as.character(alignContigs$aln[[4]]), "---TACTTTATTTTAGGCGTCTGAGCAGGAATGGTAGGAGCTGGTATAAGACTCCTAATTCGAATTGAGCTAAGACAGCCGGGAGCATTCCTAGGAAGGGATCAGCTCTATAATACTATTGTAACTGCTCACGCATTTGTAATAATTTTCTTTCTAGTAATACCTGTATTTATTGGGGGGTTCGGTAATTGACTTCTACCTTTAATACTTGGAGCCCCTGACATGGCATTCCCACGACTTAACAACATAAGATTCTGACTCCTTCCCCCGTCACTAATTCTTCTAGTGTCCTCTGCTGCAGTAGAAAAAGGTGCAGGAACTGGATGAACTGTTTATCCGCCCCTAGCAAGAAATATTGCTCATGCCGGCCCATCTGTAGACTTAGCTATTTTTTCTCTTCATTTAGCGGGTGCTTCATCAATCTTAGGGGCCATTAATTTTATTACTACTGTTATTAACATGCGATGAAGAGGCTTACGACTTGAACGAATCCCATTATTCGTTTGAGCCGTACTAATCACAGTGGTGCTTCTACTCCTATCCCTACCAGTGTTAGCCGGTGCAATTACTATATTACTTACCGATCGAAATCTAAATACCTCCTTCTTTGATCCTGCTGGGGGTGGAGAT---------------------------------------------")
    expect_equal(length(alignContigs$aln.tree), 4)
})

test_that("'calculateContigSeq' function test", {
    forwardReadList <- sangerContig@forwardReadList
    reverseReadList <- sangerContig@reverseReadList
    refAminoAcidSeq <- sangerContig@refAminoAcidSeq
    minFractionCall <- sangerContig@minFractionCall
    maxFractionLost <- sangerContig@maxFractionLost
    geneticCode <- sangerContig@geneticCode
    acceptStopCodons <- sangerContig@acceptStopCodons
    readingFrame <- sangerContig@readingFrame
    contigSeq <- calculateContigSeq (inputSource = "ABIF",
                                     forwardReadList, reverseReadList,
                                     refAminoAcidSeq, minFractionCall,
                                     maxFractionLost, geneticCode,
                                     acceptStopCodons, readingFrame, 1)
    expect_equal(as.character(contigSeq$consensusGapfree), "TTATATTTTATTCTGGGCGTCTGAGCAGGAATGGTTGGAGCCGGTATAAGACTTCTAATTCGAATCGAGCTAAGACAACCAGGAGCGTTCCTGGGCAGAGACCAACTATACAATACTATCGTTACTGCACACGCATTTGTAATAATCTTCTTTCTAGTAATGCCTGTATTCATCGGGGGATTCGGAAACTGGCTTTTACCTTTAATACTTGGAGCCCCCGATATAGCATTCCCTCGACTCAACAACATGAGATTCTGACTACTTCCCCCATCACTGATCCTTTTAGTGTCCTCTGCGGCGGTAGAAAAAGGCGCTGGTACGGGGTGAACTGTTTATCCGCCTCTAGCAAGAAATCTTGCCCACGCAGGCCCGTCTGTAGATTTAGCCATCTTTTCCCTTCATTTAGCGGGTGCGTCTTCTATTCTAGGGGCTATTAATTTTATCACCACAGTTATTAATATGCGTTGAAGAGGATTACGTCTTGAACGAATTCCCCTGTTTGTCTGAGCTGTGCTAATTACAGTTGTTCTTCTACTTCTATCTTTACCAGTGCTAGCAGGTGCCATTACCATACTTCTTACCGACCGAAACCTCAATACTTCATTCTTTGATCCTGCCGGTGGTGGAGACCCCATCCTC")
    expect_equal(length(contigSeq$aln2), 3)
    expect_equal(as.character(contigSeq$aln2[[1]]), "------------CTGGGCGTCTGAGCAGGAATGGTTGGAGCCGGTATAAGACTTCTAATTCGAATCGAGCTAAGACAACCAGGAGCGTTCCTGGGCAGAGACCAACTATACAATACTATCGTTACTGCACACGCATTTGTAATAATCTTCTTTCTAGTAATGCCTGTATTCATCGGGGGATTCGGAAACTGGCTTTTACCTTTAATACTTGGAGCCCCCGATATAGCATTCCCTCGACTCAACAACATGAGATTCTGACTACTTCCCCCATCACTGATCCTTTTAGTGTCCTCTGCGGCGGTAGAAAAAGGCGCTGGTACGGGGTGAACTGTTTATCCGCCTCTAGCAAGAAATCTTGCCCACGCAGGCCCGTCTGTAGATTTAGCCATCTTTTCCCTTCATTTAGCGGGTGCGTCTTCTATTCTAGGGGCTATTAATTTTATCACCACAGTTATTAATATGCGTTGAAGA------------------------------------------------------------------------------------------------------------------------------------------------------------------------")
    expect_equal(as.character(contigSeq$aln2[[2]]), "TTATATTTTATTCTGGGCGTCTGAGCAGGAATGGTTGGAGCCGGTATAAGACTTCTAATTCGAATCGAGCTAAGACAACCAGGAGCGTTCCTGGGCAGAGACCAACTATACAATACTATCGTTACTGCACACGCATTTGTAATAATCTTCTTTCTAGTAATGCCTGTATTCATCGGGGGATTCGGAAACTGGCTTTTACCTTTAATACTTGGAGCCCCCGATATAGCATTCCCTCGACTCAACAACATGAGATTCTGACTACTTCCCCCATCACTGATCCTTTTAGTGTCCTCTGCGGCGGTAGAAAAAGGCGCTGGTACGGGGTGAACTGTTTATCCGCCTCTAGCAAGAAATCTTGCCCACGCAGGCCCGTCTGTAGATTTAGCCATCTTTTCCCTTCATTTAGCGGGTGCGTCTTCTATTCTAGGGGCTATTAATTTTATCACCACAGTTATTAATATGCGTTGAAGAGGATTACGTCTTGAACGAATTCCCCTGTTTGTCTGAGCTGTGCTAATTACAGTTGTTCTTCTACTTCTATCTTTACCAGTGCTAGCAGGTGCCATTACCATACTTCTTACCGACCGAAACCTCAATACTTCATTCTTTGATCCTGCCGGTGGTGGAGACCCCATCCTC")
    expect_equal(as.character(contigSeq$aln2[[3]]), "TTATATTTTATTCTGGGCGTCTGAGCAGGAATGGTTGGAGCCGGTATAAGACTTCTAATTCGAATCGAGCTAAGACAACCAGGAGCGTTCCTGGGCAGAGACCAACTATACAATACTATCGTTACTGCACACGCATTTGTAATAATCTTCTTTCTAGTAATGCCTGTATTCATCGGGGGATTCGGAAACTGGCTTTTACCTTTAATACTTGGAGCCCCCGATATAGCATTCCCTCGACTCAACAACATGAGATTCTGACTACTTCCCCCATCACTGATCCTTTTAGTGTCCTCTGCGGCGGTAGAAAAAGGCGCTGGTACGGGGTGAACTGTTTATCCGCCTCTAGCAAGAAATCTTGCCCACGCAGGCCCGTCTGTAGATTTAGCCATCTTTTCCCTTCATTTAGCGGGTGCGTCTTCTATTCTAGGGGCTATTAATTTTATCACCACAGTTATTAATATGCGTTGAAGAGGATTACGTCTTGAACGAATTCCCCTGTTTGTCTGAGCTGTGCTAATTACAGTTGTTCTTCTACTTCTATCTTTACCAGTGCTAGCAGGTGCCATTACCATACTTCTTACCGACCGAAACCTCAATACTTCATTCTTTGATCCTGCCGGTGGTGGAGACCCCATCCTC")
})

test_that("'MakeBaseCallsInside' function test - forward", {
    traceMatrixF <- sangerReadF@traceMatrix
    peakPosMatrixRawF <- sangerReadF@peakPosMatrixRaw
    qualityPhredScoresRawF <- sangerReadF@abifRawData@data$PCON.2
    signalRatioCutoffF <- sangerReadF@ChromatogramParam@signalRatioCutoff
    readFeatureF <- sangerReadF@readFeature
    baseCallRes <- MakeBaseCallsInside (traceMatrixF, peakPosMatrixRawF,
                                        qualityPhredScoresRawF,
                                        signalRatioCutoffF, readFeatureF,
                                        printLevel="SangerRead")
    expect_equal(length(baseCallRes$primarySeq), length(sangerReadF@primarySeq))
    expect_equal(length(baseCallRes$secondarySeq), length(sangerReadF@secondarySeq))
    expect_equal(as.character(baseCallRes$primarySeq), "CACTTTATATTTTATTCTGGGCGTCTGAGCAGGAATGGTTGGAGCCGGTATAAGACTTCTAATTCGAATCGAGCTAAGACAACCAGGAGCGTTCCTGGGCAGAGACCAACTATACAATACTATCGTTACTGCACACGCATTTGTAATAATCTTCTTTCTAGTAATGCCTGTATTCATCGGGGGATTCGGAAACTGGCTTTTACCTTTAATACTTGGAGCCCCCGATATAGCATTCCCTCGACTCAACAACATGAGATTCTGACTACTTCCCCCATCACTGATCCTTTTAGTGTCCTCTGCGGCGGTAGAAAAAGGCGCTGGTACGGGGTGAACTGTTTATCCGCCTCTAGCAAGAAATCTTGCCCACGCAGGCCCGTCTGTAGATTTAGCCATCTTTTCCCTTCATTTAGCGGGTGCGTCTTCTATTCTAGGGGCTATTAATTTTATCACCACAGTTATTAATATGCGTTGAAGAGGATTACGTCTTGAACGAATTCCCCTGTTTGTCTGAGCTGTGCTAATTACAGTTGTTCTTCTACTTCTATCTTTACCAGTGCTAGCAGGTGCCATTACCATACTTCTTACCGACCGAAACCTCAATACTTCATTCTTTGATCCTGCCGGTGGTGGAGACCCCATCCTCTACTAGCACTTATTCTGATTTTTAGATCACCCTGATGTTGAGTCATACTGAATTCCTGA")
    expect_equal(as.character(baseCallRes$secondarySeq), "TACTTTATATTTTATTCTGGGCGTCTGAGCAGGAATGGTTGGAGCCGGTATAAGACTTCTAATTCGAATCGAGCTAAGACAACCAGGAGCGTTCCTGGGCAGAGACCAACTATACAATACTATCGTTACTGCACACGCATTTGTAATAATCTTCTTTCTAGTAATGCCTGTATTCATCGGGGGATTCGGAAACTGGCTTTTACCTTTAATACTTGGAGCCCCCGATATAGCATTCCCTCGACTCAACAACATGAGATTCTGACTACTTCCCCCATCACTGATCCTTTTAGTGTCCTCTGCGGCGGTAGAAAAAGGCGCTGGTACGGGGTGAACTGTTTATCCGCCTCTAGCAAGAAATCTTGCCCACGCAGGCCCGTCTGTAGATTTAGCCATCTTTTCCCTTCATTTAGCGGGTGCGTCTTCTATTCTAGGGGCTATTAATTTTATCACCACAGTTATTAATATGCGTTGAAGAGGATTACGTCTTGAACGAATTCCCCTGTTTGTCTGAGCTGTGCTAATTACAGTTGTTCTTCTACTTCTATCTTTACCAGTGCTAGCAGGTGCCATTACCATACTTCTTACCGACCGAAACCTCAATACTTCATTCTTTGATCCTGCCGGTGGTGGAGACCCCATCCTCTACTAGCACTTATTCTGATTTTTCGATCACCCTGATGTTGAGTCATAGTGAATTCCTGA")
})

test_that("'MakeBaseCallsInside' function test - reverse", {
    traceMatrixR <- sangerReadR@traceMatrix
    peakPosMatrixRawR <- sangerReadR@peakPosMatrixRaw
    qualityPhredScoresRawR <- sangerReadR@abifRawData@data$PCON.2
    signalRatioCutoffR <- sangerReadR@ChromatogramParam@signalRatioCutoff
    readFeatureR <- sangerReadR@readFeature
    baseCallRes <- MakeBaseCallsInside (traceMatrixR, peakPosMatrixRawR,
                                        qualityPhredScoresRawR,
                                        signalRatioCutoffR, readFeatureR,
                                        printLevel="SangerRead")
    expect_equal(length(baseCallRes$primarySeq), length(sangerReadR@primarySeq))
    expect_equal(length(baseCallRes$secondarySeq), length(sangerReadR@secondarySeq))
    expect_equal(as.character(baseCallRes$primarySeq), "CCGTAGTAGGTGTTGGTAGAGGATGGGGTCTCCACCACCGGCAGGATCAAAGAATGAAGTATTGAGGTTTCGGTCGGTAAGAAGTATGGTAATGGCACCTGCTAGCACTGGTAAAGATAGAAGTAGAAGAACAACTGTAATTAGCACAGCTCAGACAAACAGGGGAATTCGTTCAAGACGTAATCCTCTTCAACGCATATTAATAACTGTGGTGATAAAATTAATAGCCCCTAGAATAGAAGACGCACCCGCTAAATGAAGGGAAAAGATGGCTAAATCTACAGACGGGCCTGCGTGGGCAAGATTTCTTGCTAGAGGCGGATAAACAGTTCACCCCGTACCAGCGCCTTTTTCTACCGCCGCAGAGGACACTAAAAGGATCAGTGATGGGGGAAGTAGTCAGAATCTCATGTTGTTGAGTCGAGGGAATGCTATATCGGGGGCTCCAAGTATTAAAGGTAAAAGCCAGTTTCCGAATCCCCCGATGAATACAGGCATTACTAGAAAGAAGATTATTACAAATGCGTGTGCAGTAACGATAGTATTGTATAGTTGGTCTCTGCCCAGGAACGCTCCTGGTTGTCTTAGCTCGATTCGAATTAGAAGTCTTATACCGGCTCCAACCATTCCTGCTCAGACGCCCAGAATAAAATATAAAGTTCCAATATCTTTATGATTTGTTGACCACTGGCCGTCGATATACAA")
    expect_equal(as.character(baseCallRes$secondarySeq), "CAGCAGTAGGTGTTGGTAGAGGATGGGGTCTCCACCACCGGCAGGATCAAAGAATGAAGTATTGCGGTTTCGGTCGGTAAGAAGTATGGTAATGGCACCTGCTAGCACTGGTAAAGATAGAAGTAGAAGAACAACTGTAATTAGCACAGCTCAGACAAACAGGGGAATTCGTTCAAGACGTAATCCTCTTCAACGCATATTAATAACTGTGGTGATAAAATTAATAGCCCCTAGAATAGAAGACGCACCCGCTAAATGAAGGGAAAAGATGGCTAAATCTACAGACGGGCCTGCGTGGGCAAGATTTCTTGCTAGAGGCGGATAAACAGTTCACCCCGTACCAGCGCCTTTTTCTACCGCCGCAGAGGACACTAAAAGGATCAGTGATGGGGGAAGTAGTCAGAATCTCATGTTGTTGAGTCGAGGGAATGCTATATCGGGGGCTCCAAGTATTAAAGGTAAAAGCCAGTTTCCGAATCCCCCGATGAATACAGGCATTACTAGAAAGAAGATTATTACAAATGCGTGTGCAGTAACGATAGTATTGTATAGTTGGTCTCTGCCCAGGAACGCTCCTGGTTGTCTTAGCTCGATTCGAATTAGAAGTCTTATACCGGCTCCAACCATTCCTGCTCAGACGCCCAGAATAAAATATAAAGTTCCAATATCTTTATGATTTGTTGACCACTGGCCGTCGATGTACAA")
})

test_that("'M1inside_calculate_trimming' function test 1", {
    qualityPhredScores <- sangerReadF@QualityReport@qualityPhredScores
    qualityBaseScores <- sangerReadF@QualityReport@qualityBaseScores
    M1TrimmingCutoff <- sangerReadF@QualityReport@M1TrimmingCutoff
    m1Trimming <- M1inside_calculate_trimming(qualityPhredScores,
                                              qualityBaseScores,
                                              0.0001)
    expect_equal(m1Trimming[["rawSeqLength"]], 702)
    expect_equal(m1Trimming[["rawMeanQualityScore"]], 52.87607, , tolerance=1e-6)
    expect_equal(m1Trimming[["rawMinQualityScore"]], 1)
    expect_equal(m1Trimming[["trimmedStartPos"]], 16)
    expect_equal(m1Trimming[["trimmedFinishPos"]], 477)
    expect_equal(m1Trimming[["trimmedSeqLength"]], 461)
    expect_equal(m1Trimming[["trimmedMeanQualityScore"]], 58.21041, tolerance=1e-6)
    expect_equal(m1Trimming[["trimmedMinQualityScore"]], 13)
    expect_equal(m1Trimming[["remainingRatio"]], 0.6566952, tolerance=1e-6)
})


test_that("'M1inside_calculate_trimming' function test 2", {
    qualityPhredScores <- sangerReadF@QualityReport@qualityPhredScores
    qualityBaseScores <- sangerReadF@QualityReport@qualityBaseScores
    M1TrimmingCutoff <- sangerReadF@QualityReport@M1TrimmingCutoff
    m1Trimming <- M1inside_calculate_trimming(qualityPhredScores,
                                              qualityBaseScores,
                                              0.01)
    expect_equal(m1Trimming[["rawSeqLength"]], 702)
    expect_equal(m1Trimming[["rawMeanQualityScore"]], 52.87607, , tolerance=1e-6)
    expect_equal(m1Trimming[["rawMinQualityScore"]], 1)
    expect_equal(m1Trimming[["trimmedStartPos"]], 8)
    expect_equal(m1Trimming[["trimmedFinishPos"]], 679)
    expect_equal(m1Trimming[["trimmedSeqLength"]], 671)
    expect_equal(m1Trimming[["trimmedMeanQualityScore"]], 54.48286, tolerance=1e-6)
    expect_equal(m1Trimming[["trimmedMinQualityScore"]], 8)
    expect_equal(m1Trimming[["remainingRatio"]], 0.9558405, tolerance=1e-6)
})

test_that("'M1inside_calculate_trimming' function test 3", {
    qualityPhredScores <- sangerReadF@QualityReport@qualityPhredScores
    qualityBaseScores <- sangerReadF@QualityReport@qualityBaseScores
    M1TrimmingCutoff <- sangerReadF@QualityReport@M1TrimmingCutoff
    m1Trimming <- M1inside_calculate_trimming(qualityPhredScores,
                                              qualityBaseScores,
                                              1)
    expect_equal(m1Trimming[["rawSeqLength"]], 702)
    expect_equal(m1Trimming[["rawMeanQualityScore"]], 52.87607, , tolerance=1e-6)
    expect_equal(m1Trimming[["rawMinQualityScore"]], 1)
    expect_equal(m1Trimming[["trimmedStartPos"]], 1)
    expect_equal(m1Trimming[["trimmedFinishPos"]], 702)
    expect_equal(m1Trimming[["trimmedSeqLength"]], 701)
    expect_equal(m1Trimming[["trimmedMeanQualityScore"]], 52.94864, tolerance=1e-6)
    expect_equal(m1Trimming[["trimmedMinQualityScore"]], 1)
    expect_equal(m1Trimming[["remainingRatio"]], 0.9985755, tolerance=1e-6)
})

test_that("'M1inside_calculate_trimming' function test 4", {
    qualityPhredScores <- sangerReadF@QualityReport@qualityPhredScores
    qualityBaseScores <- sangerReadF@QualityReport@qualityBaseScores
    M1TrimmingCutoff <- sangerReadF@QualityReport@M1TrimmingCutoff
    m1Trimming <- M1inside_calculate_trimming(qualityPhredScores,
                                              qualityBaseScores,
                                              0)
    expect_equal(m1Trimming[["rawSeqLength"]], 702)
    expect_equal(m1Trimming[["rawMeanQualityScore"]], 52.87607, , tolerance=1e-6)
    expect_equal(m1Trimming[["rawMinQualityScore"]], 1)
    expect_equal(m1Trimming[["trimmedStartPos"]], 1)
    expect_equal(m1Trimming[["trimmedFinishPos"]], 2)
    expect_equal(m1Trimming[["trimmedSeqLength"]], 1)
    expect_equal(m1Trimming[["trimmedMeanQualityScore"]], 4, tolerance=1e-6)
    expect_equal(m1Trimming[["trimmedMinQualityScore"]], 4)
    expect_equal(m1Trimming[["remainingRatio"]], 0.001424501, tolerance=1e-6)
})

test_that("'M2inside_calculate_trimming' function test 1", {
    qualityPhredScores <- sangerReadF@QualityReport@qualityPhredScores
    m2Trimming <- M2inside_calculate_trimming(qualityPhredScores,
                                              40,
                                              14)

    expect_equal(m2Trimming[["rawSeqLength"]], 702)
    expect_equal(m2Trimming[["rawMeanQualityScore"]], 52.87607, , tolerance=1e-6)
    expect_equal(m2Trimming[["rawMinQualityScore"]], 1)
    expect_equal(m2Trimming[["trimmedStartPos"]], 21)
    expect_equal(m2Trimming[["trimmedFinishPos"]], 666)
    expect_equal(m2Trimming[["trimmedSeqLength"]], 645)
    expect_equal(m2Trimming[["trimmedMeanQualityScore"]], 55.41085, tolerance=1e-6)
    expect_equal(m2Trimming[["trimmedMinQualityScore"]], 15)
    expect_equal(m2Trimming[["remainingRatio"]], 0.9188034, tolerance=1e-6)
})

test_that("'M2inside_calculate_trimming' function test 2", {
    qualityPhredScores <- sangerReadF@QualityReport@qualityPhredScores
    m2Trimming <- M2inside_calculate_trimming(qualityPhredScores,
                                              45,
                                              12)

    expect_equal(m2Trimming[["rawSeqLength"]], 702)
    expect_equal(m2Trimming[["rawMeanQualityScore"]], 52.87607, , tolerance=1e-6)
    expect_equal(m2Trimming[["rawMinQualityScore"]], 1)
    expect_equal(m2Trimming[["trimmedStartPos"]], 37)
    expect_equal(m2Trimming[["trimmedFinishPos"]], 645)
    expect_equal(m2Trimming[["trimmedSeqLength"]], 608)
    expect_equal(m2Trimming[["trimmedMeanQualityScore"]], 56.42105, tolerance=1e-6)
    expect_equal(m2Trimming[["trimmedMinQualityScore"]], 19)
    expect_equal(m2Trimming[["remainingRatio"]], 0.8660969, tolerance=1e-6)
})

