% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{clusterCounts}
\alias{clusterCounts}
\title{Count occurrences of k-mer clusters}
\usage{
clusterCounts(kmers, seqs, directional = TRUE, overlap = FALSE)
}
\arguments{
\item{kmers}{character vector or XStringSet of k-mers composing
cluster to search for, or a named list of such character
vectors or XStringSet objects to count multiple clusters.}

\item{seqs}{character vector or XStringSet of sequences in which to
search for and count occurrences of kmers.}

\item{directional}{logical value: if FALSE, counts occurrences of
either cluster(s) of k-mers or their reverse-complements. Makes
sense only if applying to DNA sequences!}

\item{overlap}{logical value: should overlapping occurrences of
k-mers be counted as multiple hits?}
}
\value{
if cluster is a single character vector or XStringSet
    (of any length), returns integer vector of counts;
    if cluster is a list of character vectors, returns matrix of
    counts: one row per sequence in seqs, one column per
    character vector/XStringSet in cluster
}
\description{
Counts how often any k-mer from a cluster of k-mers (or list of
clusters of k-mers) occurs in each element of a character vector.
}
\examples{
seqs <- c(
    line1 = "My mind's got a mind of its own",
    line2 = "Takes me out to parties when I'd rather be alone",
    line3 = "Takes me out a-walkin' when I'd rather be at home"
)
clusters <- list(
    antisocial = c('alone', 'at home'),
    mind = 'mind'
)
clCounts <- clusterCounts(clusters, seqs)

}
