% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findIndex.R
\name{findIndex}
\alias{findIndex}
\title{findIndex}
\usage{
findIndex(SCdat, condition = "condition")
}
\arguments{
\item{SCdat}{An object of class \code{SingleCellExperiment} that contains 
normalized single-cell expression and metadata. The \code{assays} 
  slot contains a named list of matrices, where the normalized counts are 
  housed in the one named \code{normcounts}.  This matrix should have one
   row for each gene and one sample for each column.  
  The \code{colData} slot should contain a data.frame with one row per 
  sample and columns that contain metadata for each sample.  This data.frame
  should contain a variable that represents biological condition, which is 
  in the form of numeric values (either 1 or 2) that indicates which 
  condition each sample belongs to (in the same order as the columns of 
  \code{normcounts}).  Optional additional metadata about each cell can also
  be contained in this data.frame, and additional information about the 
  experiment can be contained in the \code{metadata} slot as a list.}

\item{condition}{A character object that contains the name of the column in 
\code{colData} that represents 
 the biological group or condition of interest (e.g. treatment versus 
 control).  Note that this variable should only contain two 
 possible values since \code{scDD} can currently only handle two-group 
 comparisons.  The default option assumes that there
 is a column named "condition" that contains this variable.}
}
\value{
Vector of indices for a reasonable set of genes that can be used 
for simulation.
}
\description{
Find a reasonable set of genes (one mode and at least 25% nonzero values) 
to use for simulation.
}
\references{
Korthauer KD, Chu LF, Newton MA, Li Y, Thomson J, Stewart R, 
Kendziorski C. A statistical approach for identifying differential 
distributions
in single-cell RNA-seq experiments. Genome Biology. 2016 Oct 25;17(1):222. 
\url{https://genomebiology.biomedcentral.com/articles/10.1186/s13059-016-
1077-y}
}
