% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsampleByVar.R
\name{downsampleByVar}
\alias{downsampleByVar}
\title{Downsample an input data-frame or matrix based on variance.}
\usage{
downsampleByVar(x, varianceFactor = 0.1, verbose = TRUE)
}
\arguments{
\item{x}{Input data-matrix.}

\item{varianceFactor}{Removes this proportion of variables based on
lesser variance.}

\item{verbose}{Boolean (TRUE / FALSE) to print messages to console or not.}
}
\value{
A \code{matrix} object.
}
\description{
Downsample an input data-frame or matrix based on variance.
}
\details{
Downsample an input data-frame or matrix based on variance.
}
\examples{
# create random data that follows a negative binomial
mat <- jitter(matrix(
  MASS::rnegbin(rexp(1000, rate=.1), theta = 4.5),
  ncol = 20))

downsampleByVar(mat, varianceFactor = 0.1)

}
\author{
Kevin Blighe <kevin@clinicalbioinformatics.co.uk>
}
