% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getArtificialDoublets.R
\name{addDoublets}
\alias{addDoublets}
\title{addDoublets}
\usage{
addDoublets(
  x,
  clusters,
  dbr = (0.01 * ncol(x)/1000),
  only.heterotypic = TRUE,
  adjustSize = FALSE,
  prefix = "doublet.",
  ...
)
}
\arguments{
\item{x}{A count matrix of singlets, or a
\code{\link[SummarizedExperiment]{SummarizedExperiment-class}}}

\item{clusters}{A vector of cluster labels for each column of `x`}

\item{dbr}{The doublet rate}

\item{only.heterotypic}{Whether to add only heterotypic doublets.}

\item{adjustSize}{Whether to adjust the library sizes of the doublets.}

\item{prefix}{Prefix for the colnames generated.}

\item{...}{Any further arguments to \code{\link{createDoublets}}.}
}
\value{
A `SingleCellExperiment` with the colData columns `cluster` and
`type` (indicating whether the cell is a singlet or doublet).
}
\description{
Adds artificial doublets to an existing dataset
}
\examples{
sce <- mockDoubletSCE(dbl.rate=0)
sce <- addDoublets(sce, clusters=sce$cluster)
}
