% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_adjacency.R
\name{generate_adjacency}
\alias{generate_adjacency}
\title{Generate Adjacency Matrices from Gene Interaction Tables}
\usage{
generate_adjacency(df_list, nCores = 1)
}
\arguments{
\item{df_list}{A list of data frames. Each data frame must have three
columns:
\describe{
\item{Gene1}{Character. First gene in the interaction.}
\item{Gene2}{Character. Second gene in the interaction.}
\item{Weight}{Numeric. Weight or strength of the interaction from
\code{Gene1} to \code{Gene2}.}
}}

\item{nCores}{Integer. Number of CPU cores to use for parallel
processing. Defaults to the number of available workers from the
current \pkg{BiocParallel} backend.}
}
\value{
A \linkS4class{SummarizedExperiment} object where each assay is a
square numeric adjacency matrix (p×p genes). Diagonal entries are set to
zero (no self-interactions).
}
\description{
Constructs adjacency matrices from a list of data frames (network edge lists)
and returns them in a \linkS4class{SummarizedExperiment} object.
}
\details{
The function first identifies all unique genes across all data
frames to define the matrix dimensions. For each interaction table,
it places the corresponding weights at the appropriate gene-pair
positions. Parallelization is handled by \pkg{BiocParallel} for
improved performance on multiple datasets.

Missing weights (\code{NA}) are ignored during construction. Only
gene pairs matching the global gene list are inserted.
}
\examples{
data("toy_counts")

# Infer networks (toy_counts is already a MultiAssayExperiment)
networks <- infer_networks(
    count_matrices_list = toy_counts,
    method = "GENIE3",
    nCores = 1
)
head(networks[[1]])

# Generate adjacency matrices
wadj_se <- generate_adjacency(networks) # returns SummarizedExperiment
head(wadj_se[[1]])
}
