% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_py.R
\name{init_py}
\alias{init_py}
\title{Initialize Python Environment for GRNBoost2}
\usage{
init_py(
  python_path = "/usr/bin/python3",
  required = TRUE,
  install_missing = FALSE,
  install_method = "auto",
  verbose = TRUE
)
}
\arguments{
\item{python_path}{Character string. Path to the Python executable,
e.g., \code{"/usr/bin/python3"}. For optimal GRNBoost2 compatibility,
Python 3.8.x is strongly recommended.}

\item{required}{Logical. If \code{TRUE}, errors if Python is not
available or path is invalid. Default: \code{TRUE}.}

\item{install_missing}{Logical. If \code{TRUE}, automatically installs
missing Python packages. Default: \code{FALSE}.}

\item{install_method}{Character string. Installation method when
\code{install_missing = TRUE}. Options: "auto", "conda", "pip".
Default: "auto".}

\item{verbose}{Logical. If \code{TRUE}, shows installation progress.
Default: \code{TRUE}.}
}
\value{
A list with three Python module objects:
\itemize{
\item \code{arboreto}: GRNBoost2 algorithm module.
\item \code{pandas}: Data handling module.
\item \code{numpy}: Numerical operations module.
}
}
\description{
Sets up the Python environment and lazily loads modules required for
running GRNBoost2: \code{arboreto}, \code{pandas}, and \code{numpy}.
Automatically installs missing Python packages if requested.
}
\details{
Uses \pkg{reticulate} to bind R to the specified Python
interpreter and lazily import modules needed for GRNBoost2. If
\code{install_missing = TRUE}, automatically installs the 'arboreto'
package using the specified method if not found.
}
\examples{
# Initialize Python environment (handles missing modules gracefully)
tryCatch(
    {
        modules <- init_py(required = FALSE)
    },
    error = function(e) {
        message("Python environment not available: ", e$message)
    }
)
}
