% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual_static.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Heatmap plot}
\usage{
plot_heatmap(mtmutObj, type = "p", cell_ann = NULL, ann_colors = NULL, ...)
}
\arguments{
\item{mtmutObj}{an object of class "mtmutObj".}

\item{type}{a string of plot type, "p" for p-value, "af" for allele frequency.}

\item{cell_ann}{a data.frame of cell annotation, with rownames as cell barcodes, please refer to \code{\link[pheatmap]{pheatmap}} for details.}

\item{ann_colors}{a list of colors for cell annotation with cell annotation as names, please refer to \code{\link[pheatmap]{pheatmap}} for details.}

\item{...}{other parameters for \code{\link[scMitoMut]{export_df}} and \code{\link[pheatmap]{pheatmap}}.}
}
\value{
The pheatmap output
}
\description{
Heatmap plot
}
\examples{
# load the data
## Use the example data
f <- system.file("extdata", "mini_dataset.tsv.gz", package = "scMitoMut")

## Create a temporary h5 file
## In real case, we keep the h5 in project folder for future use
f_h5_tmp <- tempfile(fileext = ".h5")

## Load the data with parse_table function
f_h5 <- parse_table(f, sep = "\t", h5_file = f_h5_tmp)

# open the h5f file
x <- open_h5_file(f_h5)
# run the model fit
run_model_fit(x)
x
# Filter the loci based on the model fit results
x <- filter_loc(x, min_cell = 5, model = "bb", p_threshold = 0.05, p_adj_method = "fdr")

# set the cell annotation
f <- system.file("extdata", "mini_dataset_cell_ann.csv", package = "scMitoMut")
cell_ann <- read.csv(f, row.names = 1)
# Prepare the color for cell annotation
colors <- c(
  "Cancer Epi" = "#f28482",
  Blood = "#f6bd60"
)
ann_colors <- list("SeuratCellTypes" = colors)

# plot the heatmap for p-value
plot_heatmap(x, type = "p", cell_ann = cell_ann, ann_colors = ann_colors, percent_interp = 0.2)
# plot the heatmap for allele frequency
plot_heatmap(x, type = "af", cell_ann = cell_ann, ann_colors = ann_colors, percent_interp = 0.2)
# plot the heatmap for binary mutation
plot_heatmap(x, type = "binary", cell_ann = cell_ann, ann_colors = ann_colors, percent_interp = 0.2)
}
