% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SCE_methods.R
\docType{methods}
\name{demultiplex_info}
\alias{demultiplex_info}
\alias{demultiplex_info<-}
\alias{demultiplex_info.sce}
\alias{demultiplex_info,SingleCellExperiment-method}
\alias{demultiplex_info<-,SingleCellExperiment-method}
\title{demultiplex_info}
\usage{
demultiplex_info(object)

demultiplex_info(object) <- value

demultiplex_info.sce(object)

\S4method{demultiplex_info}{SingleCellExperiment}(object)

\S4method{demultiplex_info}{SingleCellExperiment}(object) <- value
}
\arguments{
\item{object}{A \code{\link{SingleCellExperiment}} object.}

\item{value}{Value to be assigned to corresponding object.}
}
\value{
a dataframe of cell barcode demultiplex information

A DataFrame of cell barcode demultiplx results.
}
\description{
Get or set cell barcode demultiplex results in a SingleCellExperiment object
}
\examples{
data("sc_sample_data")
data("sc_sample_qc")
sce = SingleCellExperiment(assays = list(counts = as.matrix(sc_sample_data)))
organism(sce) = "mmusculus_gene_ensembl"
gene_id_type(sce) = "ensembl_gene_id"
QC_metrics(sce) = sc_sample_qc
demultiplex_info(sce) = cell_barcode_matching
UMI_dup_info(sce) = UMI_duplication

demultiplex_info(sce)

}
\author{
Luyi Tian
}
