% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5ToSce.R
\name{h5ToSce}
\alias{h5ToSce}
\title{Function: h5ToSce
This function takes the path of an h5 file and reads this into an object of
the SingleCellExperiment class.}
\usage{
h5ToSce(h5_file)
}
\arguments{
\item{h5_file}{path of an h5 file}
}
\value{
A list containing the following elements:
\describe{
  \item{sce_amp}{SingleCellExperiment class object containing read count
  information.}
  \item{se_var}{SummarizedExperiment class object containing variant
  information..}
}

A list with the SingleCellExperiment and the SummarizedExperiment
object representing the amplicon and the variant analysis.
\describe{
  \item{sce_amp}{SingleCellExperiment with amplicon experiment.}
  \item{se_var}{SummarizedExperiment with variants eexperiment}
}
}
\description{
Function: h5ToSce
This function takes the path of an h5 file and reads this into an object of
the SingleCellExperiment class.
}
\examples{
h5_file_path <- system.file("extdata", "demo.h5", package = "scafari")

# Read the h5ToSce using readH5File
result <- h5ToSce(h5_file_path)

# Display the result
result

}
