% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPanelUniformity.R
\name{plotPanelUniformity}
\alias{plotPanelUniformity}
\title{Plot Panel Uniformity}
\usage{
plotPanelUniformity(sce, interactive = FALSE)
}
\arguments{
\item{sce}{A `SingleCellExperiment` object that contains single-cell data
with a 'counts' assay. This object should be pre-processed to ensure
the data is appropriate for uniformity analysis.}

\item{interactive}{in interactive mode an plotly is returned.}
}
\value{
A `ggplot` object visualizing the uniformity of panel reads.
}
\description{
This function generates a plot to assess the uniformity of panel reads
in a `SingleCellExperiment` object. It uses read counts stored in the
'counts' assay to visualize the distribution and variability of reads.
}
\examples{
# Assume `sce` is a SingleCellExperiment object with 'counts' assay.
h5_file_path <- system.file("extdata", "demo.h5", package = "scafari")
h5 <- h5ToSce(h5_file_path)
sce <- h5$sce_amp
sce <- normalizeReadCounts(sce = sce)
uniformity_plot <- plotPanelUniformity(sce)
print(uniformity_plot)

}
